/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.repository;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.core.ListOfStringView;
import com.xebialabs.deployit.core.MapStringStringView;
import com.xebialabs.deployit.core.SetOfStringView;
import com.xebialabs.deployit.core.StringValue;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.io.DerivedArtifactFile;
import com.xebialabs.deployit.io.FileWithoutContent;
import com.xebialabs.deployit.io.SourceArtifactFile;
import com.xebialabs.deployit.jcr.JcrUtils;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.PropertyKind;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.artifact.Artifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.DerivedArtifact;
import com.xebialabs.deployit.plugin.api.udm.artifact.SourceArtifact;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import com.xebialabs.deployit.repository.JcrPathHelper;
import com.xebialabs.deployit.repository.NodeReaderContext;
import com.xebialabs.deployit.repository.NodeUtils;
import com.xebialabs.deployit.repository.OnDemandFileReader;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.SearchQueryBuilder;
import com.xebialabs.deployit.repository.StringValueConverter;
import com.xebialabs.deployit.repository.WorkDir;
import com.xebialabs.deployit.util.JavaCryptoUtils;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import java.io.Serializable;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NodeReader {
    private Session session;
    private Node node;
    private final WorkDir workDir;
    private NodeReaderContext context;
    private final PasswordEncrypter passwordEncrypter;
    private static final Logger logger = LoggerFactory.getLogger(NodeReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends ConfigurationItem> T read(Session session, Node node, WorkDir workDir, PasswordEncrypter passwordEncrypter) throws RepositoryException {
        NodeReaderContext c = NodeReaderContext.get().hold();
        try {
            T t = NodeReader.read(session, node, workDir, c, passwordEncrypter);
            return t;
        }
        finally {
            c.release();
        }
    }

    static <T extends ConfigurationItem> T read(Session session, Node node, WorkDir workDir, NodeReaderContext context, PasswordEncrypter passwordEncrypter) throws RepositoryException {
        return new NodeReader(session, node, workDir, context, passwordEncrypter).read();
    }

    private NodeReader(Session session, Node node, WorkDir workDir, NodeReaderContext context, PasswordEncrypter passwordEncrypter) {
        this.session = session;
        this.node = node;
        this.workDir = workDir;
        this.context = context;
        this.passwordEncrypter = passwordEncrypter;
    }

    private <T extends ConfigurationItem> T read() throws RepositoryException {
        String id = JcrPathHelper.getIdFromAbsolutePath(this.node.getPath());
        logger.trace("{} loading with workdir {}", (Object)id, (Object)this.workDir);
        Object item = this.checkAlreadyRead();
        if (item != null) {
            return item;
        }
        Type type = Type.valueOf((String)this.node.getProperty("$configuration.item.type").getString());
        if (!type.exists()) {
            logger.warn("While trying to read node [{}] its type [{}] was not found in any plugin. Please make sure the required plugin is installed.", (Object)this.node.getPath(), (Object)type);
            throw new TypeNotFoundException(String.format("Unknown type [%s] while reading node [%s]", type, this.node.getPath()));
        }
        Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)type);
        item = descriptor.newInstance(id);
        if (item instanceof BaseConfigurationItem && this.node.hasProperty("$token")) {
            ((BaseConfigurationItem)item).set$token(this.node.getProperty("$token").getString());
        }
        this.context.put(this.node.getIdentifier(), (ConfigurationItem)item);
        this.copyValues(item, descriptor);
        this.copyData(item, descriptor);
        return item;
    }

    private <T extends ConfigurationItem> T checkAlreadyRead() throws RepositoryException {
        if (this.context.hasItem(this.node.getIdentifier())) {
            ConfigurationItem item = this.context.get(this.node.getIdentifier());
            Descriptor descriptor = DescriptorRegistry.getDescriptor((Type)item.getType());
            if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null && ((SourceArtifact)item).getFile() instanceof FileWithoutContent) {
                this.copyData(item, descriptor);
            } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && ((DerivedArtifact)item).getFile() == null) {
                this.copyData(item, descriptor);
            }
            return (T)item;
        }
        return null;
    }

    private <T extends ConfigurationItem> void copyData(T item, Descriptor descriptor) throws RepositoryException {
        DerivedArtifact d;
        if (descriptor.isAssignableTo(SourceArtifact.class) && this.workDir != null) {
            String filename = this.node.getProperty("$filename").getString();
            if (item.hasProperty("checksum") && Strings.isBlank((String)((String)item.getProperty("checksum")))) {
                MessageDigest sha1 = JavaCryptoUtils.getSha1();
                LocalFile file = new OnDemandFileReader(item, filename, this.workDir).getLocalFile(this.session, sha1);
                ((Artifact)item).setFile((OverthereFile)file);
                String digest = JavaCryptoUtils.digest(sha1);
                item.setProperty("checksum", (Object)digest);
                this.node.setProperty("checksum", this.session.getValueFactory().createValue(digest));
                this.session.save();
            } else {
                ((Artifact)item).setFile((OverthereFile)SourceArtifactFile.create((SourceArtifact)item, filename, new OnDemandFileReader(item, filename, this.workDir)));
            }
        } else if (descriptor.isAssignableTo(SourceArtifact.class)) {
            String filename = this.node.getProperty("$filename").getString();
            ((Artifact)item).setFile((OverthereFile)new FileWithoutContent(filename));
        } else if (descriptor.isAssignableTo(DerivedArtifact.class) && this.workDir != null && (d = (DerivedArtifact)item).getSourceArtifact() != null) {
            d.setFile((OverthereFile)DerivedArtifactFile.create(d));
            OverthereFile sourceFile = d.getSourceArtifact().getFile();
            if (sourceFile instanceof FileWithoutContent) {
                d.getSourceArtifact().setFile((OverthereFile)SourceArtifactFile.create(d.getSourceArtifact(), sourceFile.getName(), new OnDemandFileReader((ConfigurationItem)d.getSourceArtifact(), sourceFile.getName(), this.workDir)));
            }
        }
    }

    private <T extends ConfigurationItem> void copyValues(T item, Descriptor descriptor) throws RepositoryException {
        block10: for (PropertyDescriptor pd : descriptor.getPropertyDescriptors()) {
            if (!NodeReader.hasProperty(this.node, pd) && !pd.isAsContainment()) {
                logger.trace("Repository node [{}] does not contain value for (non-containment) property [{}]. Using the default value.", (Object)item.getId(), (Object)pd);
                this.wrapDefaultValue(item, pd);
                continue;
            }
            if (pd.isTransient()) {
                if (NodeReader.hasProperty(this.node, pd)) {
                    logger.debug("Repository node [{}] contains transient property [{}] which should not have been persisted.", (Object)item.getId(), (Object)pd);
                }
                logger.trace("Not attempting to read transient property [{}] from repository node [{}]. Using the default value.", (Object)pd, (Object)item.getId());
                this.wrapDefaultValue(item, pd);
                continue;
            }
            switch (pd.getKind()) {
                case BOOLEAN: 
                case INTEGER: 
                case STRING: 
                case ENUM: {
                    this.setPrimitiveProperty(item, pd);
                    continue block10;
                }
                case DATE: {
                    pd.set(item, (Object)this.node.getProperty(pd.getName()).getDate().getTime());
                    continue block10;
                }
                case SET_OF_STRING: {
                    pd.set(item, (Object)new SetOfStringView(Sets.newHashSet(this.getCollectionOfStringValues(pd))));
                    continue block10;
                }
                case SET_OF_CI: {
                    pd.set(item, (Object)Sets.newHashSet(this.getCollectionOfConfigurationItemValues(item, pd)));
                    continue block10;
                }
                case LIST_OF_STRING: {
                    pd.set(item, (Object)new ListOfStringView(Lists.newArrayList(this.getCollectionOfStringValues(pd))));
                    continue block10;
                }
                case LIST_OF_CI: {
                    pd.set(item, (Object)Lists.newArrayList(this.getCollectionOfConfigurationItemValues(item, pd)));
                    continue block10;
                }
                case CI: {
                    this.setConfigurationItemProperty(item, pd);
                    continue block10;
                }
                case MAP_STRING_STRING: {
                    this.copyMapPropertyFromNode(item, pd);
                    continue block10;
                }
            }
            throw new IllegalStateException("Unsupported property kind: " + pd.getKind());
        }
    }

    private <T extends ConfigurationItem> void wrapDefaultValue(T item, PropertyDescriptor pd) {
        Serializable newValue;
        Object value = pd.get(item);
        if (pd.getKind() == PropertyKind.SET_OF_STRING) {
            newValue = SetOfStringView.from((Set)value);
        } else if (pd.getKind() == PropertyKind.LIST_OF_STRING) {
            newValue = ListOfStringView.from((List)value);
        } else if (pd.getKind() == PropertyKind.MAP_STRING_STRING) {
            newValue = MapStringStringView.from((Map)value);
        } else {
            return;
        }
        logger.trace("Wrapping default value [{}] in property [{}] of CI [{}]", new Object[]{value, pd.getFqn(), item.getId()});
        pd.set(item, (Object)newValue);
    }

    private static boolean hasProperty(Node node, PropertyDescriptor pd) throws RepositoryException {
        if (node.hasProperty(pd.getName())) {
            return true;
        }
        for (String s : pd.getAliases()) {
            if (!node.hasProperty(s)) continue;
            return true;
        }
        return false;
    }

    private static Property getProperty(Node node, PropertyDescriptor pd) throws RepositoryException {
        if (node.hasProperty(pd.getName())) {
            return node.getProperty(pd.getName());
        }
        for (String s : pd.getAliases()) {
            if (!node.hasProperty(s)) continue;
            return node.getProperty(s);
        }
        throw new IllegalStateException("Should have found a property on the node " + node.getPath() + " for propertydescriptor " + pd.getFqn());
    }

    private <T extends ConfigurationItem> void copyMapPropertyFromNode(T item, PropertyDescriptor pd) throws RepositoryException {
        Property property = NodeReader.getProperty(this.node, pd);
        Map<String, String> value = JcrUtils.readMap(property);
        MapStringStringView mapStringStringView = new MapStringStringView(Maps.newHashMap((Map)Maps.transformValues(value, StringValueConverter.stringToValue(this.passwordEncrypter))));
        pd.set(item, (Object)mapStringStringView);
    }

    private <T extends ConfigurationItem> void setConfigurationItemProperty(T item, PropertyDescriptor pd) throws RepositoryException {
        Node referencedNode;
        if (pd.isAsContainment()) {
            if (this.node.isNodeType("nt:frozenNode")) {
                logger.debug("Reading parent of frozen node [{}]", (Object)this.node.getPath());
                Node realNode = this.session.getNodeByIdentifier(this.node.getProperty("jcr:frozenUuid").getString());
                referencedNode = realNode.getParent();
            } else {
                referencedNode = this.node.getParent();
            }
        } else {
            Value value = NodeReader.getProperty(this.node, pd).getValue();
            referencedNode = NodeUtils.getReferencedCiNode(this.node, value, this.session);
        }
        pd.set(item, (Object)this.readReference(referencedNode));
    }

    private <T extends ConfigurationItem> Collection<ConfigurationItem> getCollectionOfConfigurationItemValues(T item, PropertyDescriptor pd) throws RepositoryException {
        ArrayList items = Lists.newArrayList();
        if (pd.isAsContainment() && pd.getKind() == PropertyKind.SET_OF_CI) {
            SearchParameters params = new SearchParameters().setParent(item.getId()).setType(pd.getReferencedType());
            Query query = new SearchQueryBuilder(params).createTemplate().createQuery(this.session);
            QueryResult queryResult = query.execute();
            NodeIterator iterator = queryResult.getNodes();
            while (iterator.hasNext()) {
                Node referencedNode = iterator.nextNode();
                items.add(this.readReference(referencedNode));
            }
        } else {
            for (Value each : NodeReader.getProperty(this.node, pd).getValues()) {
                Node referencedNode = NodeUtils.getReferencedCiNode(this.node, each, this.session);
                items.add(this.readReference(referencedNode));
            }
        }
        return items;
    }

    private ConfigurationItem readReference(Node referencedNode) throws RepositoryException {
        return NodeReader.read(this.session, referencedNode, this.workDir, this.context, this.passwordEncrypter);
    }

    private Collection<StringValue> getCollectionOfStringValues(PropertyDescriptor pd) throws RepositoryException {
        StringValueConverter converter = new StringValueConverter(this.passwordEncrypter);
        ArrayList list = Lists.newArrayList();
        for (Value v : NodeReader.getProperty(this.node, pd).getValues()) {
            list.add(converter.convert(v.getString()));
        }
        return list;
    }

    private <T extends ConfigurationItem> void setPrimitiveProperty(T item, PropertyDescriptor pd) throws RepositoryException {
        String valueAsString = NodeReader.getProperty(this.node, pd).getString();
        if (pd.getKind() == PropertyKind.STRING && pd.isPassword()) {
            valueAsString = this.passwordEncrypter.ensureDecrypted(valueAsString);
        }
        pd.set(item, (Object)valueAsString);
    }

    @HttpResponseCodeResult(statusCode=500)
    public static class TypeNotFoundException
    extends DeployitException {
        public TypeNotFoundException(String message) {
            super(message);
        }
    }
}

