/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing;

import com.google.common.annotations.VisibleForTesting;
import com.xebialabs.deployit.core.rest.xml.Converters;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.xltype.serialization.json.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/json"})
public class PropertyDescriptorJsonWriter
implements MessageBodyWriter<PropertyDescriptor> {
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return true;
    }

    public long getSize(PropertyDescriptor propertyDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(PropertyDescriptor propertyDescriptor, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        entityStream.write(this.toJson(propertyDescriptor).getBytes());
    }

    @VisibleForTesting
    String toJson(PropertyDescriptor propertyDescriptor) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter writer = new JsonWriter((Writer)stringWriter);
        PropertyDescriptorJsonWriter.writePropertyDescriptor(writer, propertyDescriptor);
        return stringWriter.toString();
    }

    static void writePropertyDescriptor(JsonWriter writer, PropertyDescriptor propertyDescriptor) {
        writer.object();
        writer.key("name").value((Object)propertyDescriptor.getName());
        writer.key("fqn").value((Object)propertyDescriptor.getFqn());
        writer.key("label").value((Object)propertyDescriptor.getLabel());
        writer.key("kind").value((Object)propertyDescriptor.getKind().name());
        writer.key("description").value((Object)propertyDescriptor.getDescription());
        writer.key("category").value((Object)propertyDescriptor.getCategory());
        writer.key("asContainment").value((Object)Converters.bool((boolean)propertyDescriptor.isAsContainment()));
        writer.key("inspection").value((Object)Converters.bool((boolean)propertyDescriptor.isInspectionProperty()));
        writer.key("required").value((Object)Converters.bool((boolean)propertyDescriptor.isRequired()));
        writer.key("requiredInspection").value((Object)Converters.bool((boolean)propertyDescriptor.isRequiredForInspection()));
        writer.key("password").value((Object)Converters.bool((boolean)propertyDescriptor.isPassword()));
        writer.key("transient").value((Object)Converters.bool((boolean)propertyDescriptor.isTransient()));
        writer.key("size").value((Object)propertyDescriptor.getSize().name());
        if (propertyDescriptor.isHidden()) {
            writer.key("hidden").value((Object)"true");
        }
        writer.endObject();
    }
}

