/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import java.io.File;

public class Environment {
    public static final String DEFAULT_WEB_PATH = "../../../web/";
    public static final File WEB_PATH = new File(System.getProperty("Releaseit.WebPath", "../../../web/"));
    public static final String DEFAULT_SPRING_CONFIG = "classpath:spring/xlrelease-context.xml,classpath:xl-release-security.xml,classpath*:hotfix-context.xml";
    public static final String DEVMODE = "RELEASEITDEVMODE";

    public boolean isProduction() {
        return System.getenv(DEVMODE) == null;
    }

    public boolean isDevelopment() {
        return !this.isProduction();
    }

    public String getSpringConfig() {
        if (this.isProduction()) {
            return DEFAULT_SPRING_CONFIG;
        }
        String springSecurityFile = System.getenv("SPRING_SECURITY_FILE");
        if (springSecurityFile == null) {
            return DEFAULT_SPRING_CONFIG;
        }
        return DEFAULT_SPRING_CONFIG.replace("xl-release-security.xml", springSecurityFile);
    }

    public File getWebPath() {
        return WEB_PATH;
    }
}

