/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease;

import com.google.common.base.Strings;
import com.xebialabs.deployit.ServerConfiguration;
import com.xebialabs.deployit.booter.local.LocalBooter;
import com.xebialabs.deployit.core.rest.resteasy.Mime4jStorageProvider;
import com.xebialabs.deployit.engine.spi.event.SystemStartedEvent;
import com.xebialabs.deployit.event.EventBusHolder;
import com.xebialabs.deployit.event.ShutdownEvent;
import com.xebialabs.deployit.jetty.DeployitSpringContextLoaderListener;
import com.xebialabs.deployit.jetty.FlexRestCompatibilityFilter;
import com.xebialabs.xlrelease.wro.WroFilter;
import java.net.InetAddress;
import java.security.Provider;
import java.security.Security;
import java.util.EventListener;
import java.util.concurrent.CountDownLatch;
import nl.javadude.t2bus.Subscribe;
import org.apache.james.mime4j.storage.DefaultStorageProvider;
import org.apache.james.mime4j.storage.StorageProvider;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jboss.resteasy.plugins.server.servlet.HttpServletDispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrap;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.bio.SocketConnector;
import org.mortbay.jetty.security.SslSocketConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.FilterHolder;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.jetty.webapp.WebAppContext;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.DelegatingFilterProxy;

public class XLReleaseServer {
    private static final String SPRING_CTX_CFG_LOCATION_KEY = "contextConfigLocation";
    private final ServerConfiguration serverConfiguration;
    private final String name;
    private final String springConfig;
    private Server server;
    private Context context;
    private static volatile CountDownLatch shutdownLatch = new CountDownLatch(1);
    private static final Logger logger = LoggerFactory.getLogger(XLReleaseServer.class);

    public XLReleaseServer(String name, ServerConfiguration configuration, String springConfig, String contextPath) {
        this.serverConfiguration = configuration;
        this.name = name;
        this.springConfig = springConfig;
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.context = new WebAppContext();
        this.context.setContextPath(contextPath);
        this.setupJetty();
        XLReleaseServer.bootPlugins();
        this.setupSpring();
        this.setupRest();
        this.setupWro4J();
        this.server.setHandler((Handler)this.context);
    }

    private void setupWro4J() {
        this.context.addFilter(WroFilter.class, "/wro/*", 0);
    }

    private void setupJetty() {
        int port = this.serverConfiguration.getHttpPort();
        String documentRootPackage = "web";
        if (logger.isDebugEnabled()) {
            logger.debug("Setting up Jetty server on port {} with context root {} using package {} for document root.", new Object[]{port, this.context, documentRootPackage});
        }
        this.server = new Server();
        SocketConnector connector = new SocketConnector();
        if (this.serverConfiguration.isSsl()) {
            connector = this.setupSSL(connector);
        }
        connector.setHost(this.serverConfiguration.getHttpBindAddress());
        connector.setPort(port);
        this.server.addConnector((Connector)connector);
        BoundedThreadPool btp = new BoundedThreadPool();
        btp.setMinThreads(this.serverConfiguration.getMinThreads());
        btp.setMaxThreads(this.serverConfiguration.getMaxThreads());
        this.server.setThreadPool((ThreadPool)btp);
        this.server.setGracefulShutdown(1000);
    }

    private SocketConnector setupSSL(SocketConnector connector) {
        logger.debug("Setting up Jetty to use SSL");
        SslSocketConnector sslConnector = new SslSocketConnector();
        connector.setMaxIdleTime(30000);
        sslConnector.setKeystore(this.serverConfiguration.getKeyStorePath());
        sslConnector.setPassword(this.serverConfiguration.getKeyStorePassword());
        sslConnector.setKeyPassword(this.serverConfiguration.getKeyStoreKeyPassword());
        String protocol = this.serverConfiguration.getSslProtocol();
        if (!Strings.nullToEmpty((String)protocol).trim().isEmpty()) {
            sslConnector.setProtocol(protocol);
        }
        connector = sslConnector;
        return connector;
    }

    private static void bootPlugins() {
        LocalBooter.boot();
    }

    private void setupSpring() {
        ServerConfiguration.setInstance((ServerConfiguration)this.serverConfiguration);
        this.context.getInitParams().put(SPRING_CTX_CFG_LOCATION_KEY, this.springConfig);
        if (logger.isDebugEnabled()) {
            logger.debug("Using Spring configuration - " + this.springConfig);
        }
        FilterHolder filter = new FilterHolder(DelegatingFilterProxy.class);
        filter.setName("springSecurityFilterChain");
        this.context.addFilter(filter, "/*", 1);
        this.context.addFilter(FlexRestCompatibilityFilter.class, "*", 0);
    }

    private void setupRest() {
        this.context.addEventListener((EventListener)new ResteasyBootstrap());
        this.context.addEventListener((EventListener)new DeployitSpringContextLoaderListener());
        ServletHolder servletHolder = new ServletHolder(HttpServletDispatcher.class);
        this.context.getInitParams().put("resteasy.servlet.mapping.prefix", "/");
        this.context.getInitParams().put("resteasy.document.expand.entity.references", "false");
        this.context.addServlet(servletHolder, "/*");
        this.context.setResourceBase(".");
        DefaultStorageProvider.setInstance((StorageProvider)new Mime4jStorageProvider());
    }

    public void start() {
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting Jetty");
            }
            this.server.start();
            DeployitSpringContextLoaderListener.checkCorrectlyInitialized();
            logger.info("{} has started.", (Object)this.name);
            this.createShutdownEventThreadAndShutdownHook();
            String host = (this.serverConfiguration.isSsl() ? "https" : "http") + "://" + InetAddress.getLocalHost().getHostName() + ":" + this.serverConfiguration.getHttpPort() + this.serverConfiguration.getWebContextRoot();
            logger.info("You can now point your browser to {}", (Object)host);
            EventBusHolder.publish((Object)new SystemStartedEvent());
        }
        catch (Exception e) {
            logger.error("Error occured while starting Jetty", (Throwable)e);
            this.stop();
        }
    }

    private synchronized void stop() {
        if (this.server.isRunning()) {
            logger.info("Shutting down {}.", (Object)this.name);
            try {
                this.server.stop();
                logger.info("{} has shut down.", (Object)this.name);
            }
            catch (Exception e) {
                logger.error("Error occurred while trying to stop Jetty", (Throwable)e);
            }
        }
    }

    private void createShutdownEventThreadAndShutdownHook() {
        Thread shutdownEventThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    shutdownLatch.await();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                logger.trace("Shutting down {} because a shutdown event was received.", (Object)XLReleaseServer.this.name);
                XLReleaseServer.this.stop();
            }
        });
        shutdownEventThread.start();
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                logger.trace("Shutting down {} because the process is being terminated.", (Object)XLReleaseServer.this.name);
                XLReleaseServer.this.stop();
            }
        }));
        EventBusHolder.register((Object)this);
    }

    public Context getContext() {
        return this.context;
    }

    @Subscribe
    public void shutdownListener(ShutdownEvent event) {
        logger.trace("Received shutdown event.");
        shutdownLatch.countDown();
    }
}

