/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseActivitiesFormatter;
import com.xebialabs.xlrelease.views.PhaseForm;
import java.util.ArrayList;
import java.util.List;

public class PhaseFieldsComparator {
    private Phase original;
    private PhaseForm updated;

    public PhaseFieldsComparator(Phase original, PhaseForm updated) {
        this.original = original;
        this.updated = updated;
    }

    public List<ActivityLogEntry> getLogs() {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivities.PHASE_RENAMED.create(this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries.add(ReleaseActivities.PHASE_DESCRIPTION_UPDATED.create(this.updated.getTitle(), this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries.add(ReleaseActivities.PHASE_DUE_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivitiesFormatter.formatDate(this.original.getDueDate()), ReleaseActivitiesFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivities.PHASE_SCHEDULED_START_DATE_UPDATED.create(this.updated.getTitle(), ReleaseActivitiesFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivitiesFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)this.original.getColor(), (Object)this.updated.getColor())) {
            logEntries.add(ReleaseActivities.PHASE_COLOR_CHANGED.create(this.updated.getTitle(), this.original.getColor(), this.updated.getColor()));
        }
        return logEntries;
    }
}

