/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.activity.ReleaseVariablesComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseActivitiesFormatter;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.views.ReleaseForm;
import java.util.ArrayList;
import java.util.List;

public class ReleaseFieldsComparator {
    private Release original;
    private ReleaseForm updated;

    public ReleaseFieldsComparator(Release original, ReleaseForm updated) {
        this.original = original;
        this.updated = updated;
    }

    public List<ActivityLogEntry> getLogs() {
        ActivityLogEntry variablesLog;
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivities.RELEASE_TITLE_UPDATED.create(this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries.add(ReleaseActivities.RELEASE_DESCRIPTION_UPDATED.create(this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries.add(ReleaseActivities.RELEASE_DUE_DATE_UPDATED.create(ReleaseActivitiesFormatter.formatDate(this.original.getDueDate()), ReleaseActivitiesFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivities.RELEASE_SCHEDULED_START_DATE_UPDATED.create(ReleaseActivitiesFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivitiesFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)this.original.getOwner(), (Object)this.updated.getOwner())) {
            logEntries.add(ReleaseActivities.RELEASE_OWNER_UPDATED.create(ReleaseActivitiesFormatter.quoteAssignee(this.original.getOwner()), ReleaseActivitiesFormatter.quoteAssignee(this.updated.getOwner())));
        }
        if (!Objects.equal(this.original.getTags(), this.updated.getTags())) {
            logEntries.add(ReleaseActivities.RELEASE_TAGS_UPDATED.create(this.updated.getTags() != null ? Sets.newHashSet(this.updated.getTags()) : null));
        }
        if (!this.original.isTemplate() && !Objects.equal((Object)((Object)this.original.getFlagStatus()), (Object)((Object)this.updated.getFlag().getStatus()))) {
            logEntries.add(ReleaseActivities.RELEASE_FLAG_STATUS_UPDATED.create(new Object[]{this.original.getFlagStatus(), this.updated.getFlag().getStatus()}));
        }
        if (!this.original.isTemplate() && !Objects.equal((Object)this.original.getFlagComment(), (Object)this.updated.getFlag().getComment())) {
            logEntries.add(ReleaseActivities.RELEASE_FLAG_COMMENT_UPDATED.create(this.original.getFlagComment(), this.updated.getFlag().getComment()));
        }
        if ((variablesLog = new ReleaseVariablesComparator(this.original.getVariableValues(), Variable.listToMap(this.updated.getVariables())).getLogEntry()) != null) {
            logEntries.add(variablesLog);
        }
        return logEntries;
    }
}

