/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Preconditions;
import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.CommentView;
import javax.ws.rs.Consumes;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/comments")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class CommentResource {
    private Comments comments;
    private Tasks tasks;
    private PermissionChecker permissions;

    @Autowired
    public CommentResource(Comments comments, Tasks tasks, PermissionChecker permissions) {
        this.comments = comments;
        this.tasks = tasks;
        this.permissions = permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{commentId}")
    public CommentView updateComment(@PathParam(value="commentId") @IdParam String commentId, CommentView commentView) {
        Object object = ReleaseLock.of(commentId);
        synchronized (object) {
            this.permissions.checkEditTask(Ids.releaseIdFrom(commentId));
            Task task = this.tasks.findById(Ids.getParentId(commentId));
            Preconditions.checkArgument((!task.isDefunct() ? 1 : 0) != 0, (Object)"Can't update comment on defunct task");
            return new CommentView(this.comments.update(commentId, commentView.getText()));
        }
    }
}

