/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.ReleaseEditor;
import com.xebialabs.xlrelease.views.TeamView;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.resteasy.annotations.cache.NoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/teams")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@NoCache
@Controller
public class TeamResource {
    private Releases releases;
    private ReleaseEditor releaseEditor;
    private PermissionChecker permissions;

    @Autowired
    public TeamResource(Releases releases, ReleaseEditor releaseEditor, PermissionChecker permissions) {
        this.releases = releases;
        this.releaseEditor = releaseEditor;
        this.permissions = permissions;
    }

    @GET
    @Path(value="/release/{releaseId}")
    public List<TeamView> getTeamsOfRelease(@PathParam(value="releaseId") @IdParam String releaseId) {
        this.permissions.checkView(releaseId);
        Release release = this.releases.findById(releaseId);
        return Lists.transform(release.getTeams(), TeamView.TO_TEAM_VIEW);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="/release/{releaseId}")
    public TeamView addTeam(@PathParam(value="releaseId") @IdParam String releaseId, TeamView teamView) {
        Object object = ReleaseLock.of(releaseId);
        synchronized (object) {
            this.permissions.checkEdit(releaseId);
            Release release = this.releases.findById(releaseId);
            Team team = this.releaseEditor.addTeam(release, teamView.toTeam());
            return new TeamView(team);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{teamId}")
    public void deleteTeam(@PathParam(value="teamId") @IdParam String teamId) {
        Object object = ReleaseLock.of(teamId);
        synchronized (object) {
            this.permissions.checkEdit(Ids.releaseIdFrom(teamId));
            Release release = this.releases.containingTeam(teamId);
            this.releaseEditor.deleteTeam(release, teamId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{teamId}")
    public TeamView updateTeam(@PathParam(value="teamId") @IdParam String teamId, TeamView newTeam) {
        Object object = ReleaseLock.of(teamId);
        synchronized (object) {
            this.permissions.checkEdit(Ids.releaseIdFrom(teamId));
            Team team = this.releaseEditor.updateTeam(teamId, newTeam.toTeam());
            return new TeamView(team);
        }
    }
}

