/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;

public class PhaseBuilder {
    private String id;
    private String title;
    private PhaseStatus status;
    private List<Task> tasks;
    private Release release;
    private Date scheduledStartDate;
    private DateTime startDate;
    private Date dueDate;
    private DateTime endDate;
    private String description;

    private PhaseBuilder() {
    }

    public static PhaseBuilder newPhase() {
        return new PhaseBuilder().withRelease(new Release());
    }

    public PhaseBuilder withId(String id) {
        this.id = id;
        return this;
    }

    public PhaseBuilder withTitle(String title) {
        this.title = title;
        return this;
    }

    public PhaseBuilder withIdAndTitle(String id) {
        this.id = id;
        this.title = id;
        return this;
    }

    public PhaseBuilder withDescription(String description) {
        this.description = description;
        return this;
    }

    public PhaseBuilder withStatus(PhaseStatus status) {
        this.status = status;
        return this;
    }

    public PhaseBuilder withTasks(Task ... tasks) {
        this.tasks = Lists.newArrayList((Object[])tasks);
        return this;
    }

    public PhaseBuilder withRelease(Release release) {
        this.release = release;
        return this;
    }

    public PhaseBuilder withScheduledStartDate(Date date) {
        this.scheduledStartDate = date;
        return this;
    }

    public PhaseBuilder withStartDate(DateTime date) {
        this.startDate = date;
        return this;
    }

    public PhaseBuilder withDueDate(Date date) {
        this.dueDate = date;
        return this;
    }

    public PhaseBuilder withEndDate(DateTime date) {
        this.endDate = date;
        return this;
    }

    public Phase build() {
        Phase phase = (Phase)new Phase().getType().getDescriptor().newInstance(this.id);
        phase.setStatus(this.status);
        phase.setTitle(this.title);
        phase.setDescription(this.description);
        phase.setRelease(this.release);
        phase.setScheduledStartDate(this.scheduledStartDate != null ? this.scheduledStartDate : null);
        phase.setStartDate(this.startDate != null ? this.startDate.toDate() : null);
        phase.setDueDate(this.dueDate != null ? this.dueDate : null);
        phase.setEndDate(this.endDate != null ? this.endDate.toDate() : null);
        if (null != this.tasks) {
            for (Task task : this.tasks) {
                task.setContainer(phase);
            }
            phase.setTasks(this.tasks);
        }
        return phase;
    }
}

