/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.PostStartAction;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class NotificationTask
extends Task {
    @Property
    private Set<String> addresses;
    @Property
    private String subject;
    @Property
    private String body;

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
    }

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        HashSet newAddresses = Sets.newHashSet();
        for (String address : this.addresses) {
            newAddresses.add(this.replaceAll(address, variables, unresolvedVariables, freezeEvenIfUnresolved));
        }
        this.addresses = newAddresses;
        this.setSubject(this.replaceAll(this.getSubject(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        this.setBody(this.replaceAll(this.getBody(), variables, unresolvedVariables, freezeEvenIfUnresolved));
        return unresolvedVariables;
    }

    @Override
    protected Changes execute(String targetId, ReleaseActivities activity) {
        Changes changes = super.execute(targetId, activity);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        changes.addPostStartAction(new PostStartAction(){

            @Override
            public void run(ExecutionService executionService) {
                executionService.sendNotification(NotificationTask.this);
            }
        });
        return changes;
    }

    public Set<String> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(Set<String> addresses) {
        this.addresses = addresses;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}

