/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import java.util.Date;
import java.util.List;

public class ParallelGroup
extends Task {
    @Property(asContainment=true, required=false)
    private List<Task> tasks = Lists.newArrayList();

    public List<Task> getTasks() {
        return this.tasks;
    }

    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    @Override
    public List<Task> getAllTasks() {
        List<Task> allTasks = super.getAllTasks();
        for (Task task : this.tasks) {
            allTasks.addAll(task.getAllTasks());
        }
        return allTasks;
    }

    @Override
    public Changes startNow(String targetId, boolean shouldBePending) {
        Changes changes = null;
        if (this.getId().equals(targetId)) {
            changes = super.startNow(this.getId(), shouldBePending);
            for (Task subTask : this.tasks) {
                changes.addAll(subTask.start());
            }
        } else {
            for (Task subTask : this.tasks) {
                if (!targetId.startsWith(subTask.getId())) continue;
                changes = subTask.startNow(targetId, shouldBePending);
                break;
            }
        }
        if (changes == null) {
            changes = new Changes();
        }
        this.updateGroupStatusIfNecessary(changes);
        return changes;
    }

    @Override
    public Changes markAsDone(String targetId, TaskStatus status) {
        if (this.getId().equals(targetId)) {
            throw new UnsupportedOperationException("completing/skipping a whole parallel group is not currently supported");
        }
        Changes changes = null;
        for (Task subTask : this.tasks) {
            if (!targetId.startsWith(subTask.getId())) continue;
            changes = subTask.markAsDone(targetId, status);
            break;
        }
        if (changes == null) {
            changes = new Changes();
        }
        this.updateGroupStatusIfNecessary(changes);
        return changes;
    }

    @Override
    public Changes fail(String targetId, String failReason) {
        if (this.getId().equals(targetId)) {
            throw new UnsupportedOperationException("failing a whole parallel group as a whole is not currently supported");
        }
        Changes changes = null;
        for (Task subTask : this.tasks) {
            if (!targetId.startsWith(subTask.getId())) continue;
            changes = subTask.fail(targetId, failReason);
            break;
        }
        if (changes == null) {
            changes = new Changes();
        }
        this.updateGroupStatusIfNecessary(changes);
        return changes;
    }

    @Override
    public Changes retry(String targetId) {
        if (this.getId().equals(targetId)) {
            throw new UnsupportedOperationException("retrying a whole parallel group is not currently supported");
        }
        Changes changes = null;
        for (Task subTask : this.tasks) {
            if (!targetId.startsWith(subTask.getId())) continue;
            changes = subTask.retry(targetId);
            break;
        }
        if (changes == null) {
            changes = new Changes();
        }
        this.updateGroupStatusIfNecessary(changes);
        return changes;
    }

    @Override
    public Changes abort() {
        Changes changes = super.abort();
        for (Task subTask : this.tasks) {
            changes.addAll(subTask.abort());
        }
        return changes;
    }

    @Override
    public Changes resetToPlanned() {
        Changes changes = super.resetToPlanned();
        for (Task task : this.getTasks()) {
            changes.addAll(task.resetToPlanned());
        }
        return changes;
    }

    private void updateGroupStatusIfNecessary(Changes changes) {
        TaskStatus newGroupStatus = ParallelGroup.computeGroupStatus(this.tasks);
        if (newGroupStatus != this.getStatus()) {
            this.setStatus(newGroupStatus);
            if (newGroupStatus == TaskStatus.IN_PROGRESS) {
                this.setStartDate(new Date());
            }
            if (newGroupStatus == TaskStatus.COMPLETED) {
                this.setEndDate(new Date());
            }
            changes.update((ConfigurationItem)this, this.logNewStatus(newGroupStatus));
        }
    }

    @VisibleForTesting
    static TaskStatus computeGroupStatus(List<Task> tasks) {
        boolean hasFailures = false;
        boolean hasInProgress = false;
        for (Task subTask : tasks) {
            if (subTask.isStarted() || subTask.isPending()) {
                hasInProgress = true;
            }
            if (!subTask.isFailed() && !subTask.isFailing()) continue;
            hasFailures = true;
        }
        if (hasFailures && hasInProgress) {
            return TaskStatus.FAILING;
        }
        if (hasFailures) {
            return TaskStatus.FAILED;
        }
        if (hasInProgress) {
            return TaskStatus.IN_PROGRESS;
        }
        return TaskStatus.COMPLETED;
    }

    private ActivityLogEntry logNewStatus(TaskStatus status) {
        switch (status) {
            case COMPLETED: {
                return ReleaseActivities.TASK_COMPLETED.create(this.getTitle());
            }
            case FAILED: {
                return ReleaseActivities.TASK_FAILED.create(this.getTitle(), "at least one subtask failed");
            }
            case IN_PROGRESS: {
                return ReleaseActivities.TASK_RESTARTED.create(this.getTitle());
            }
            case FAILING: {
                return ReleaseActivities.TASK_FAILING.create(this.getTitle());
            }
        }
        throw new IllegalArgumentException(status.name());
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
        for (Task task : this.tasks) {
            task.accept(visitor);
        }
    }
}

