/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.email;

import com.xebialabs.xlrelease.email.EmailProvider;
import com.xebialabs.xlrelease.email.LdapEmailProvider;
import com.xebialabs.xlrelease.email.NoopEmailProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.search.LdapUserSearch;
import org.springframework.stereotype.Service;

@Service
public class EmailProviderFactoryBean
implements FactoryBean<EmailProvider>,
ApplicationContextAware,
InitializingBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(EmailProviderFactoryBean.class);
    private ApplicationContext context;
    private EmailProvider provider;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }

    public void afterPropertiesSet() throws Exception {
        this.provider = this.tryInitFromSpringLdapUserSearch();
        if (this.provider == null) {
            this.provider = this.tryInitFromSpringLdapProvider();
        }
        if (this.provider == null) {
            LOGGER.info("Defaulting to {}", (Object)NoopEmailProvider.class.getSimpleName());
            this.provider = new NoopEmailProvider();
        }
    }

    public EmailProvider getObject() throws Exception {
        return this.provider;
    }

    public Class<?> getObjectType() {
        return EmailProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    private EmailProvider tryInitFromSpringLdapProvider() {
        LdapAuthenticationProvider ldapProvider = this.getSpringBean(LdapAuthenticationProvider.class);
        if (ldapProvider == null) {
            return null;
        }
        try {
            LOGGER.info("Found {} in spring context, initializing from LDAP", (Object)LdapAuthenticationProvider.class.getSimpleName());
            return new LdapEmailProvider(ldapProvider);
        }
        catch (Exception e) {
            LOGGER.warn("Error initializing from {}", (Object)LdapAuthenticationProvider.class.getSimpleName(), (Object)e);
            return null;
        }
    }

    private EmailProvider tryInitFromSpringLdapUserSearch() {
        LdapUserSearch ldapUserSearch = this.getSpringBean(LdapUserSearch.class);
        if (ldapUserSearch == null) {
            return null;
        }
        try {
            LOGGER.info("Found {} in spring context, initializing from LDAP", (Object)LdapUserSearch.class.getSimpleName());
            return new LdapEmailProvider(ldapUserSearch);
        }
        catch (Exception e) {
            LOGGER.warn("Error initializing from {}", (Object)LdapUserSearch.class.getSimpleName(), (Object)e);
            return null;
        }
    }

    private <T> T getSpringBean(Class<T> beanClass) {
        try {
            return (T)this.context.getBean(beanClass);
        }
        catch (Exception e) {
            return null;
        }
    }
}

