/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.reports;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.xlrelease.reports.AverageByMonthComputer;
import com.xebialabs.xlrelease.reports.ReleaseDuration;
import com.xebialabs.xlrelease.views.Point;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class ReleaseDurationComputer {
    private List<ReleaseDuration> releasesDuration;
    private Map<String, List<Point>> dataSeries = Maps.newHashMap();
    private List<Point> withAutomationSerie = Lists.newArrayList();
    private List<Point> withoutAutomationSerie = Lists.newArrayList();
    private AverageByMonthComputer averageComputer;
    private AverageByMonthComputer averageWithAutomationComputer;
    private AverageByMonthComputer averageWithoutAutomationComputer;

    public ReleaseDurationComputer(List<ReleaseDuration> releasesDuration) {
        this.releasesDuration = releasesDuration;
        this.dataSeries.put(SerieTitle.DURATION_WITH_AUTOMATION.name(), this.withAutomationSerie);
        this.dataSeries.put(SerieTitle.DURATION_WITHOUT_AUTOMATION.name(), this.withoutAutomationSerie);
        if (releasesDuration.size() > 0) {
            DateTime startDate = releasesDuration.get(0).getEndDate();
            this.averageComputer = new AverageByMonthComputer(startDate);
            this.averageWithAutomationComputer = new AverageByMonthComputer(startDate);
            this.averageWithoutAutomationComputer = new AverageByMonthComputer(startDate);
        } else {
            this.dataSeries.put(SerieTitle.AVERAGE.name(), Lists.newArrayList());
            this.dataSeries.put(SerieTitle.AVERAGE_WITH_AUTOMATION.name(), Lists.newArrayList());
            this.dataSeries.put(SerieTitle.AVERAGE_WITHOUT_AUTOMATION.name(), Lists.newArrayList());
        }
    }

    public Map<String, List<Point>> getSeries() {
        if (this.releasesDuration.size() > 0) {
            for (ReleaseDuration releaseDuration : this.releasesDuration) {
                float duration = releaseDuration.getDuration();
                Point point = new Point(releaseDuration.getTitle(), releaseDuration.getEndDate().getMillis(), duration);
                this.averageComputer.add(releaseDuration.getEndDate(), duration);
                if (releaseDuration.withAutomation()) {
                    this.withAutomationSerie.add(point);
                    this.averageWithAutomationComputer.add(releaseDuration.getEndDate(), duration);
                    continue;
                }
                this.withoutAutomationSerie.add(point);
                this.averageWithoutAutomationComputer.add(releaseDuration.getEndDate(), duration);
            }
            DateTime endDate = this.releasesDuration.get(this.releasesDuration.size() - 1).getEndDate();
            this.dataSeries.put(SerieTitle.AVERAGE.name(), this.averageComputer.completeSerie(endDate));
            this.dataSeries.put(SerieTitle.AVERAGE_WITH_AUTOMATION.name(), this.averageWithAutomationComputer.completeSerie(endDate));
            this.dataSeries.put(SerieTitle.AVERAGE_WITHOUT_AUTOMATION.name(), this.averageWithoutAutomationComputer.completeSerie(endDate));
        }
        return this.dataSeries;
    }

    public static enum SerieTitle {
        DURATION_WITH_AUTOMATION,
        DURATION_WITHOUT_AUTOMATION,
        AVERAGE,
        AVERAGE_WITH_AUTOMATION,
        AVERAGE_WITHOUT_AUTOMATION;

    }
}

