/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

public class Ids {
    private static final String SEPARATOR = "/";
    private static final String RELEASE_PREFIX = "Release";
    private static final String PHASE_PREFIX = "Phase";

    private Ids() {
    }

    public static String getParentId(String id) {
        if (!id.contains(SEPARATOR)) {
            throw new IllegalArgumentException("Not a proper ID for a children: " + id);
        }
        return id.substring(0, id.lastIndexOf(SEPARATOR));
    }

    public static String releaseIdFrom(String id) {
        return Ids.findInAncestry(id, RELEASE_PREFIX);
    }

    public static String phaseIdFrom(String id) {
        return Ids.findInAncestry(id, PHASE_PREFIX);
    }

    public static boolean isPhaseId(String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Not a proper ID %s", id));
        }
        return Ids.getName(id).startsWith(PHASE_PREFIX);
    }

    private static String findInAncestry(String id, String prefix) {
        String ancestryId = id;
        while (!Ids.getName(ancestryId).startsWith(prefix)) {
            ancestryId = Ids.getParentId(ancestryId);
        }
        return ancestryId;
    }

    public static String getName(String id) {
        if (!id.contains(SEPARATOR)) {
            return id;
        }
        return id.substring(id.lastIndexOf(SEPARATOR) + 1);
    }
}

