/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.DescriptorRegistry;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.reports.ReportTimeFrame;
import java.util.ArrayList;

public class JcrPredicate {
    public static String equal(String field, String value) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(field).append(" = '").append(value).append('\'');
        return predicate.toString();
    }

    public static String greaterThan(String field, ReportTimeFrame timeFrame) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(field).append(" > CAST(").append(timeFrame.toDate()).append(" AS DATE)");
        return predicate.toString();
    }

    public static String and(String ... predicates) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(" ( ");
        predicate.append(predicates[0]);
        for (int i = 1; i < predicates.length; ++i) {
            predicate.append(" AND ");
            predicate.append(predicates[i]);
        }
        predicate.append(")");
        return predicate.toString();
    }

    public static String or(String ... predicates) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(" ( ");
        predicate.append(predicates[0]);
        for (int i = 1; i < predicates.length; ++i) {
            predicate.append(" OR ");
            predicate.append(predicates[i]);
        }
        predicate.append(")");
        return predicate.toString();
    }

    public static String as(String selector, Class clazz) {
        ArrayList predicates = Lists.newArrayList();
        predicates.add(JcrPredicate.getTypePredicate(selector, Type.valueOf((Class)clazz)));
        for (Type subtype : DescriptorRegistry.getSubtypes((Type)Type.valueOf((Class)clazz))) {
            predicates.add(JcrPredicate.getTypePredicate(selector, subtype));
        }
        return JcrPredicate.or(predicates.toArray(new String[predicates.size() - 1]));
    }

    private static String getTypePredicate(String selector, Type type) {
        StringBuilder predicate = new StringBuilder();
        predicate.append(selector).append(".[").append("$configuration.item.type").append("] = '").append(type).append('\'');
        return predicate.toString();
    }

    public static String isDescendantNode(String childSelector, String parentSelector) {
        StringBuilder predicate = new StringBuilder();
        predicate.append("ISDESCENDANTNODE(").append(childSelector).append(", ").append(parentSelector).append(")");
        return predicate.toString();
    }

    public static String isInPath(String selector, String path) {
        String pathSelector = "'" + path + "'";
        return JcrPredicate.isDescendantNode(selector, pathSelector);
    }

    public static String notNull(String field) {
        return field + " IS NOT NULL";
    }
}

