/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.repository;

import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.repository.SearchParameters;
import com.xebialabs.deployit.repository.core.Directory;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.email.EmailProvider;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class UserProfiles {
    public static final String ROOT = Metadata.ConfigurationItemRoot.CONFIGURATION.getRootNodeName() + "/Users";
    private RepositoryService repositoryService;
    private EmailProvider emailProvider;

    @Autowired
    public UserProfiles(RepositoryService repositoryService, EmailProvider emailProvider) {
        this.repositoryService = repositoryService;
        this.emailProvider = emailProvider;
    }

    public UserProfile findByLogin(String userName) {
        return (UserProfile)this.repositoryService.read(this.buildId(userName));
    }

    public List<UserProfile> findAll() {
        SearchParameters query = new SearchParameters().setType(Type.valueOf(UserProfile.class));
        return this.repositoryService.listEntities(query);
    }

    public String getNotificationEmail(String userName) {
        if (userName == null) {
            return null;
        }
        if ((userName = userName.trim()).isEmpty()) {
            return null;
        }
        UserProfile profile = this.createOrUpdateWithExternalEmail(userName, false);
        return profile == null ? null : profile.getEmail();
    }

    public void ensureUpToDate(String userName) {
        this.createOrUpdateWithExternalEmail(userName, true);
    }

    private UserProfile createOrUpdateWithExternalEmail(String userName, boolean createIfNoEmail) {
        UserProfile profile;
        String id = this.buildId(userName);
        boolean needsSave = false;
        if (this.repositoryService.exists(id)) {
            String externalEmail;
            profile = (UserProfile)this.repositoryService.read(id);
            if (Strings.isNullOrEmpty((String)profile.getEmail()) && (externalEmail = this.emailProvider.getEmail(userName)) != null) {
                profile.setEmail(externalEmail);
                needsSave = true;
            }
        } else {
            String externalEmail = this.emailProvider.getEmail(userName);
            if (externalEmail != null || createIfNoEmail) {
                profile = new UserProfile(id, externalEmail);
                needsSave = true;
            } else {
                profile = null;
            }
        }
        if (needsSave) {
            this.save(profile);
        }
        return profile;
    }

    public void save(UserProfile profile) {
        this.ensureRootDirExists();
        this.repositoryService.createOrUpdate((ConfigurationItem[])new UserProfile[]{profile});
    }

    private String buildId(String userName) {
        return ROOT + "/" + userName;
    }

    private void ensureRootDirExists() {
        if (!this.repositoryService.exists(ROOT)) {
            Directory directory = new Directory();
            directory.setId(ROOT);
            this.repositoryService.create((ConfigurationItem[])new Directory[]{directory});
        }
    }
}

