/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.script;

import java.io.FilePermission;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.PropertyPermission;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class ScriptExecutor {
    public static final String ENGINE = "python";
    private AccessControlContext accessControlContext;
    private ScriptEngine scriptEngine;

    public ScriptExecutor(ScriptContext context, PermissionCollection permissions) {
        this.scriptEngine = this.initScriptEngine(context);
        this.accessControlContext = this.initAccessControlContext(permissions);
    }

    public void evalScript(final String script) throws Throwable {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ScriptException {
                    ScriptExecutor.this.scriptEngine.eval(script);
                    return null;
                }
            }, this.accessControlContext);
        }
        catch (PrivilegedActionException exceptionWrapper) {
            throw exceptionWrapper.getCause();
        }
    }

    private ScriptEngine initScriptEngine(ScriptContext context) {
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName(ENGINE);
        engine.setContext(context);
        return engine;
    }

    private AccessControlContext initAccessControlContext(PermissionCollection permissions) {
        ProtectionDomain domain = new ProtectionDomain(new CodeSource(null, (Certificate[])null), this.extendsMinimalPermissionsWith(permissions));
        return new AccessControlContext(new ProtectionDomain[]{domain});
    }

    private Permissions extendsMinimalPermissionsWith(PermissionCollection permissions) {
        Permissions minimalPermissions = new Permissions();
        minimalPermissions.add(new PropertyPermission("user.dir", "read"));
        minimalPermissions.add(new RuntimePermission("createClassLoader"));
        minimalPermissions.add(new RuntimePermission("getProtectionDomain"));
        this.addJythonLibrariesReadPermission(minimalPermissions);
        if (permissions != null) {
            Enumeration<Permission> permissionEnumeration = permissions.elements();
            while (permissionEnumeration.hasMoreElements()) {
                minimalPermissions.add(permissionEnumeration.nextElement());
            }
        }
        return minimalPermissions;
    }

    private void addJythonLibrariesReadPermission(Permissions minimalPermissions) {
        String classPath = System.getProperty("java.class.path");
        String classPathSeparator = System.getProperty("path.separator");
        Pattern pattern = Pattern.compile("([^" + classPathSeparator + "]*jython-standalone[^" + classPathSeparator + "]*)");
        Matcher matcher = pattern.matcher(classPath);
        while (matcher.find()) {
            minimalPermissions.add(new FilePermission(matcher.group(), "read"));
        }
    }
}

