/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plumbing.scheduler.Scheduler;
import com.xebialabs.deployit.repository.ChangeSet;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.activity.PermissionsLogFormatter;
import com.xebialabs.xlrelease.activity.ReleaseFieldsComparator;
import com.xebialabs.xlrelease.activity.ReleaseVariablesComparator;
import com.xebialabs.xlrelease.concurrent.ReleaseLock;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.PythonScript;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivities;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.notification.Notifications;
import com.xebialabs.xlrelease.repository.ActivityLog;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.Teams;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.MovementIndexes;
import com.xebialabs.xlrelease.views.ReleaseForm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseEditor {
    static final String TEMPLATE_OWNER_TEAMNAME = "Template Owner";
    static final String RELEASE_ADMIN_TEAMNAME = "Release Admin";
    private RepositoryService repositoryService;
    private Tasks tasks;
    private Teams teams;
    private Phases phases;
    private Releases releases;
    private ActivityLog activityLog;
    private Scheduler scheduler;
    private Notifications notifications;
    private static final Pattern CAPTURE_RETRY_COUNT_PATTERN = Pattern.compile("\\(([0-9]+)\\)$");

    @Autowired
    public ReleaseEditor(RepositoryService repositoryService, Tasks tasks, Teams teams, Phases phases, Releases releases, ActivityLog activityLog, Scheduler scheduler, Notifications notifications) {
        this.repositoryService = repositoryService;
        this.tasks = tasks;
        this.teams = teams;
        this.phases = phases;
        this.releases = releases;
        this.activityLog = activityLog;
        this.scheduler = scheduler;
        this.notifications = notifications;
    }

    public Team addTeam(Release release, Team team) {
        Preconditions.checkArgument((!release.isDefunct() ? 1 : 0) != 0, (Object)"Can't add team to a defunct release");
        Team addedTeam = this.teams.create(release, team);
        release.addTeam(addedTeam);
        this.activityLog.log(release.getId(), ReleaseActivities.TEAM_CREATED.create(team.getTeamName()));
        return addedTeam;
    }

    public Team updateTeam(String teamId, Team newTeam) {
        String releaseId = Ids.releaseIdFrom(teamId);
        Release release = (Release)this.repositoryService.read(releaseId);
        Preconditions.checkArgument((!release.isDefunct() ? 1 : 0) != 0, (Object)"Can't update teams of defunct release");
        Team team = (Team)this.repositoryService.read(teamId);
        team.setTeamName(newTeam.getTeamName());
        team.setMembers(newTeam.getMembers());
        this.repositoryService.update((ConfigurationItem[])new Team[]{team});
        String teamMembers = Arrays.toString(team.getMembers().toArray());
        this.activityLog.log(releaseId, ReleaseActivities.TEAM_UPDATED.create(team.getTeamName(), teamMembers));
        return team;
    }

    public void deleteTeam(Release release, String teamId) {
        Preconditions.checkArgument((!release.isDefunct() ? 1 : 0) != 0, (Object)"Can't delete team of a defunct release");
        Team team = (Team)this.repositoryService.read(teamId);
        release.deleteTeam(teamId);
        this.repositoryService.delete(new String[]{teamId});
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivities.TEAM_DELETED.create(team.getTeamName()));
    }

    public Task duplicateTask(String originTaskId) {
        Task taskToDuplicate = this.tasks.findById(originTaskId);
        PlanItem container = taskToDuplicate.getContainer();
        Preconditions.checkArgument((!(container instanceof ParallelGroup) || !((ParallelGroup)container).isStarted() ? 1 : 0) != 0, (Object)"Can't duplicate task within in progress parallel group");
        Preconditions.checkArgument((!taskToDuplicate.isDefunct() ? 1 : 0) != 0, (Object)"Can't duplicate defunct task");
        String duplicatedTaskId = this.tasks.getUniqueId(Ids.getParentId(originTaskId));
        this.repositoryService.copy(originTaskId, duplicatedTaskId);
        Task duplicatedTask = (Task)this.repositoryService.read(duplicatedTaskId);
        this.saveChanges(duplicatedTask.resetToPlanned());
        this.insertTaskBelow(container, originTaskId, duplicatedTask);
        this.activityLog.log(container.getRelease().getId(), ReleaseActivities.TASK_DUPLICATED.create(duplicatedTask.getTitle()));
        return duplicatedTask;
    }

    private void insertTaskBelow(PlanItem container, String originTaskId, Task duplicatedTask) {
        List<Task> containerTasks = this.getTasks(container);
        for (int i = 0; i < containerTasks.size(); ++i) {
            Task task = containerTasks.get(i);
            if (!task.getId().equals(originTaskId)) continue;
            containerTasks.add(i + 1, duplicatedTask);
            break;
        }
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{container});
    }

    private void saveChanges(Changes changes) {
        this.repositoryService.delete(changes.toRemovedIdsArray());
        this.repositoryService.update(changes.toUpdatedItemsArray());
    }

    public Phase movePhase(Release release, MovementIndexes movementIndexes) {
        Phase movedPhase = release.movePhase(movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivities.PHASE_MOVED.create(movedPhase.getTitle()));
        return movedPhase;
    }

    public Task moveTask(MovementIndexes movementIndexes) {
        if (this.isTaskMovedWithinSameContainer(movementIndexes)) {
            return this.moveTaskWithinContainer(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetIndex());
        }
        return this.moveTaskBetweenContainers(movementIndexes.getOriginContainerId(), movementIndexes.getOriginIndex(), movementIndexes.getTargetContainerId(), movementIndexes.getTargetIndex());
    }

    private Task moveTaskWithinContainer(String containerId, Integer originIndex, Integer targetIndex) {
        PlanItem taskOrPhase = (PlanItem)this.repositoryService.read(containerId);
        List<Task> tasks = this.getTasks(taskOrPhase);
        Task taskToMove = tasks.get(originIndex);
        Preconditions.checkArgument((!taskOrPhase.isDefunct() && taskToMove.isPlanned() ? 1 : 0) != 0, (Object)"Only planned tasks can be moved");
        tasks.remove((Object)taskToMove);
        tasks.add(targetIndex, taskToMove);
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{taskOrPhase});
        this.activityLog.log(taskOrPhase.getRelease().getId(), ReleaseActivities.TASK_MOVED_WITHIN_CONTAINER.create(taskToMove.getTitle(), taskOrPhase.getTitle()));
        return taskToMove;
    }

    private List<Task> getTasks(PlanItem taskOrPhase) {
        if (taskOrPhase instanceof Phase) {
            return ((Phase)taskOrPhase).getTasks();
        }
        if (taskOrPhase instanceof ParallelGroup) {
            return ((ParallelGroup)taskOrPhase).getTasks();
        }
        throw new UnsupportedOperationException("Can't get tasks of : " + ((Object)((Object)taskOrPhase)).getClass().getName());
    }

    private boolean isTaskMovedWithinSameContainer(MovementIndexes movementIndexes) {
        return movementIndexes.getOriginContainerId().equals(movementIndexes.getTargetContainerId());
    }

    private Task moveTaskBetweenContainers(String originContainerId, Integer originIndex, String targetContainerId, Integer targetIndex) {
        PlanItem originContainer = (PlanItem)this.repositoryService.read(originContainerId);
        PlanItem targetContainer = (PlanItem)this.repositoryService.read(targetContainerId);
        List<Task> originContainerTasks = this.getTasks(originContainer);
        Task taskToMove = originContainerTasks.get(originIndex);
        List<Task> targetContainerTasks = this.getTasks(targetContainer);
        Preconditions.checkArgument((taskToMove.isPlanned() && !originContainer.isDefunct() && !targetContainer.isDefunct() ? 1 : 0) != 0, (Object)"Only planned tasks can be moved");
        Task movedTask = this.moveTask(taskToMove, this.tasks.getUniqueId(targetContainer.getId()));
        targetContainerTasks.add(targetIndex, movedTask);
        this.repositoryService.update((ConfigurationItem[])new PlanItem[]{targetContainer});
        this.activityLog.log(originContainer.getRelease().getId(), ReleaseActivities.TASK_MOVED_BETWEEN_CONTAINERS.create(taskToMove.getTitle(), originContainer.getTitle(), targetContainer.getTitle()));
        return movedTask;
    }

    private Task moveTask(Task taskToMove, String newId) {
        String oldId = taskToMove.getId();
        ChangeSet changeSet = new ChangeSet();
        changeSet.addCopyCi(oldId, newId);
        changeSet.delete((ConfigurationItem)taskToMove);
        this.repositoryService.execute(changeSet);
        return (Task)this.repositoryService.read(newId);
    }

    public Phase duplicatePhase(Release release, String originPhaseId) {
        Phase originPhase = this.phases.findById(originPhaseId);
        Preconditions.checkArgument((!originPhase.isDefunct() ? 1 : 0) != 0, (Object)"Can't duplicate defunct phase");
        String newPhaseId = this.phases.getUniqueId(release.getId());
        this.repositoryService.copy(originPhaseId, newPhaseId);
        Phase duplicatePhase = (Phase)this.repositoryService.read(newPhaseId);
        this.saveChanges(duplicatePhase.resetToPlanned());
        release.addBelow(originPhaseId, duplicatePhase);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(release.getId(), ReleaseActivities.PHASE_DUPLICATED.create(originPhase.getTitle()));
        return duplicatePhase;
    }

    public Release createTemplate(String templateTitle, String templateDescription, List<String> tags) {
        Release template = this.releases.createTemplate(templateTitle, templateDescription, tags);
        this.addFirstBlankPhase(template);
        this.addDefaultTeam(template, TEMPLATE_OWNER_TEAMNAME, XLReleasePermissions.getTemplateOnlyPermissions());
        return (Release)this.repositoryService.read(template.getId());
    }

    private void addFirstBlankPhase(Release release) {
        Phase newPhase = this.phases.create(release.getId());
        release.addPhase(newPhase);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
    }

    private void addDefaultTeam(Release release, String teamName, List<String> permissions) {
        Team team = new Team();
        team.setTeamName(teamName);
        team.setPermissions(permissions);
        team.setMembers(Lists.newArrayList((Object[])new String[]{Permissions.getAuthenticatedUserName()}));
        this.addTeam(release, team);
        this.activityLog.log(release.getId(), new PermissionsLogFormatter(release.getTeams()).getLogEntry());
    }

    public Release createWithoutTemplate(Release releaseMetadata) {
        Release release = this.releases.createWithoutTemplate(releaseMetadata);
        this.addDefaultTeam(release, RELEASE_ADMIN_TEAMNAME, XLReleasePermissions.getReleasePermissions());
        this.addFirstBlankPhase(release);
        return (Release)this.repositoryService.read(release.getId());
    }

    public Release createFromTemplate(String templateId, Release releaseMetadata) {
        Release release = this.releases.createFromTemplate(templateId, releaseMetadata);
        this.removeTemplateOwnerTeams(release);
        this.addDefaultTeam(release, RELEASE_ADMIN_TEAMNAME, XLReleasePermissions.getReleasePermissions());
        return (Release)this.repositoryService.read(release.getId());
    }

    private void removeTemplateOwnerTeams(Release release) {
        Predicate<Team> isTemplateOwnerTeam = new Predicate<Team>(){

            public boolean apply(Team team) {
                return Objects.equal((Object)team.getTeamName(), (Object)ReleaseEditor.TEMPLATE_OWNER_TEAMNAME);
            }
        };
        Collection templateOwnerTeams = Collections2.filter(release.getTeams(), (Predicate)isTemplateOwnerTeam);
        for (Team templateOwnerTeam : templateOwnerTeams) {
            this.repositoryService.delete(new String[]{templateOwnerTeam.getId()});
        }
        release.getTeams().removeAll(templateOwnerTeams);
    }

    public Release updateRelease(String releaseId, ReleaseForm releaseForm) {
        Release release = (Release)this.repositoryService.read(releaseId);
        Preconditions.checkArgument((!release.isDefunct() ? 1 : 0) != 0, (Object)"Can't update defunct release");
        List<ActivityLogEntry> logEntries = new ReleaseFieldsComparator(release, releaseForm).getLogs();
        if (releaseForm.getTitle() != null) {
            Preconditions.checkArgument((!releaseForm.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Release title is mandatory");
            release.setTitle(releaseForm.getTitle());
        }
        if (releaseForm.getDescription() != null) {
            release.setDescription(releaseForm.getDescription());
        }
        if (releaseForm.getDueDate() != null) {
            release.setDueDate(releaseForm.getDueDate());
        }
        if (releaseForm.getScheduledStartDate() != null) {
            release.setScheduledStartDate(releaseForm.getScheduledStartDate());
        }
        if (releaseForm.getOwner() != null) {
            Preconditions.checkArgument((!releaseForm.getOwner().isEmpty() ? 1 : 0) != 0, (Object)"Release owner is mandatory");
            release.setOwner(releaseForm.getOwner());
        }
        if (releaseForm.getTags() != null) {
            release.setTags(releaseForm.getTags());
        }
        release.addVariableValues(Variable.listToMap(releaseForm.getVariables()));
        this.notifyIfNecessary(release, releaseForm.getFlag().getStatus(), releaseForm.getFlag().getComment());
        if (releaseForm.getFlag().getStatus() != null) {
            release.setFlagStatus(releaseForm.getFlag().getStatus());
        }
        if (releaseForm.getFlag().getComment() != null) {
            release.setFlagComment(releaseForm.getFlag().getComment());
        }
        release.setCalendarPublished(releaseForm.isCalendarPublished());
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        this.activityLog.log(releaseId, logEntries, User.AUTHENTICATED_USER);
        return release;
    }

    private void notifyIfNecessary(Release release, FlagStatus newStatus, String flagComment) {
        if (newStatus == release.getFlagStatus() || newStatus == null || newStatus == FlagStatus.OK || release.getOwner().equals(Permissions.getAuthenticatedUserName())) {
            return;
        }
        this.notifications.notifyReleaseFlagged(release, newStatus, flagComment);
    }

    public Release updateTemplate(String templateId, ReleaseForm releaseForm, List<String> tags) {
        Release template = (Release)this.repositoryService.read(templateId);
        List<ActivityLogEntry> logEntries = new ReleaseFieldsComparator(template, releaseForm).getLogs();
        if (releaseForm.getTitle() != null) {
            Preconditions.checkArgument((!releaseForm.getTitle().isEmpty() ? 1 : 0) != 0, (Object)"Template title is mandatory");
            template.setTitle(releaseForm.getTitle());
        }
        if (releaseForm.getDescription() != null) {
            template.setDescription(releaseForm.getDescription());
        }
        template.setTags(tags);
        this.repositoryService.update((ConfigurationItem[])new Release[]{template});
        this.activityLog.log(templateId, logEntries, User.AUTHENTICATED_USER);
        return template;
    }

    public Release updateVariables(String releaseId, List<Variable> variables) {
        Release release = (Release)this.repositoryService.read(releaseId);
        Preconditions.checkArgument((!release.isDefunct() ? 1 : 0) != 0, (Object)"Can't update defunct release");
        ActivityLogEntry variablesLog = new ReleaseVariablesComparator(release.getVariableValues(), Variable.listToMap(variables)).getLogEntry();
        release.addVariableValues(Variable.listToMap(variables));
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
        if (variablesLog != null) {
            this.activityLog.log(release.getId(), variablesLog);
        }
        return release;
    }

    public Release updatePermissions(String releaseId, List<Team> teams) {
        Release release = this.releases.findById(releaseId);
        for (Team team : teams) {
            Team oldTeam = release.getTeamWithId(team.getId());
            oldTeam.setPermissions(team.getPermissions());
            this.repositoryService.update((ConfigurationItem[])new Team[]{oldTeam});
        }
        this.activityLog.log(releaseId, new PermissionsLogFormatter(release.getTeams()).getLogEntry());
        return release;
    }

    public Release restartPhasesFrom(String releaseId, String phaseId) {
        Release release = (Release)this.repositoryService.read(releaseId);
        List<Phase> phasesToRestore = this.getPhasesToRestore(release, phaseId);
        List<Phase> restoredPhases = this.restorePhases(phasesToRestore);
        this.updateGatesReferencingPhases(phasesToRestore, restoredPhases);
        this.updateRelease(release, restoredPhases);
        this.closePhase(release.getCurrentPhase());
        return (Release)this.repositoryService.read(releaseId);
    }

    @VisibleForTesting
    List<Phase> getPhasesToRestore(Release release, String phaseId) {
        Preconditions.checkArgument((boolean)release.hasPhase(phaseId), (Object)("Phase with id: '" + phaseId + "' not found in release"));
        int firstPhaseToRestoreIndex = release.getPhases().indexOf((Object)release.getPhase(phaseId));
        Preconditions.checkArgument((boolean)release.hasCurrentPhase(), (Object)"Release must have a current phase in order to restart phases");
        int currentPhaseIndex = release.getPhases().indexOf((Object)release.getCurrentPhase());
        Preconditions.checkArgument((currentPhaseIndex >= firstPhaseToRestoreIndex ? 1 : 0) != 0, (Object)"Can't restore a phase that is after the current phase");
        return release.getPhases().subList(firstPhaseToRestoreIndex, currentPhaseIndex + 1);
    }

    @VisibleForTesting
    List<Phase> restorePhases(List<Phase> phasesToRestore) {
        ArrayList restoredPhases = Lists.newArrayList();
        for (Phase phase : phasesToRestore) {
            restoredPhases.add(this.restorePhase(phase));
        }
        for (int i = 0; i < phasesToRestore.size(); ++i) {
            Phase originalPhase = phasesToRestore.get(i);
            Phase restoredPhase = (Phase)((Object)restoredPhases.get(i));
            this.restoreTasks(originalPhase.getTasks(), restoredPhase.getTasks());
        }
        return restoredPhases;
    }

    private Phase restorePhase(Phase phase) {
        String restoredPhaseId = this.phases.getUniqueId(Ids.releaseIdFrom(phase.getId()));
        this.repositoryService.copy(phase.getId(), restoredPhaseId);
        Phase copiedPhase = (Phase)this.repositoryService.read(restoredPhaseId);
        copiedPhase.setTitle(this.getRestoredPhaseTitle(phase.getTitle()));
        copiedPhase.setStatus(PhaseStatus.PLANNED);
        this.repositoryService.update((ConfigurationItem[])new Phase[]{copiedPhase});
        return copiedPhase;
    }

    @VisibleForTesting
    String getRestoredPhaseTitle(String originalTitle) {
        Matcher matcher = CAPTURE_RETRY_COUNT_PATTERN.matcher(originalTitle);
        if (matcher.find()) {
            int retryCount = Integer.parseInt(matcher.group(1));
            return matcher.replaceAll("(" + Integer.toString(retryCount + 1) + ")");
        }
        return originalTitle + " (2)";
    }

    private void restoreTasks(List<Task> originalTasks, List<Task> copiedTasks) {
        for (int i = 0; i < originalTasks.size(); ++i) {
            Task restoredTask = this.tasks.findUnstartedRevision(originalTasks.get(i).getId());
            if (restoredTask == null) {
                restoredTask = copiedTasks.get(i);
            }
            this.replaceTask(copiedTasks, i, restoredTask);
            if (!(restoredTask instanceof ParallelGroup)) continue;
            List<Task> originalSubTasks = ((ParallelGroup)originalTasks.get(i)).getTasks();
            List<Task> restoredSubTasks = ((ParallelGroup)restoredTask).getTasks();
            this.restoreTasks(originalSubTasks, restoredSubTasks);
        }
    }

    private void replaceTask(List<Task> copiedTasks, int index, Task restoredTask) {
        Task copiedTask = copiedTasks.get(index);
        restoredTask.setId(copiedTask.getId());
        this.replaceNestedCIs(restoredTask, copiedTask);
        this.reset(restoredTask, copiedTask);
        restoredTask.set$token(null);
        this.repositoryService.update((ConfigurationItem[])new Task[]{restoredTask});
        copiedTasks.set(index, restoredTask);
    }

    private void replaceNestedCIs(Task restoredTask, Task copiedTask) {
        if (restoredTask instanceof GateTask) {
            ((GateTask)restoredTask).setConditions(((GateTask)copiedTask).getConditions());
            ((GateTask)restoredTask).setDependencies(((GateTask)copiedTask).getDependencies());
        }
        if (restoredTask instanceof ParallelGroup) {
            ((ParallelGroup)restoredTask).setTasks(((ParallelGroup)copiedTask).getTasks());
        }
        if (restoredTask instanceof CustomScriptTask) {
            CustomScriptTask restoredCustomScriptTask = (CustomScriptTask)restoredTask;
            CustomScriptTask copiedCustomScriptTask = (CustomScriptTask)copiedTask;
            PythonScript copiedPythonScript = copiedCustomScriptTask.getPythonScript();
            restoredCustomScriptTask.setPythonScript(copiedPythonScript);
            copiedPythonScript.setCustomScriptTask(restoredCustomScriptTask);
        }
    }

    private void reset(Task restoredTask, Task copiedTask) {
        restoredTask.setStatus(TaskStatus.PLANNED);
        for (Comment comment : copiedTask.getComments()) {
            this.repositoryService.delete(new String[]{comment.getId()});
        }
        restoredTask.getComments().clear();
        if (restoredTask instanceof GateTask) {
            for (GateCondition condition : ((GateTask)restoredTask).getConditions()) {
                condition.setChecked(false);
                this.repositoryService.update((ConfigurationItem[])new GateCondition[]{condition});
            }
        }
        if (copiedTask instanceof CustomScriptTask) {
            CustomScriptTask copiedCustomScriptTask = (CustomScriptTask)copiedTask;
            PythonScript copiedPythonScript = copiedCustomScriptTask.getPythonScript();
            this.restoreSavedProperties(copiedCustomScriptTask, copiedPythonScript, copiedPythonScript.getPropertiesWithVariables());
            this.restoreSavedProperties(copiedCustomScriptTask, copiedPythonScript, copiedPythonScript.getOutputProperties());
            this.repositoryService.update((ConfigurationItem[])new PythonScript[]{copiedPythonScript});
        }
    }

    private void restoreSavedProperties(CustomScriptTask copiedCustomScriptTask, PythonScript copiedPythonScript, Collection<PropertyDescriptor> properties) {
        Map<String, String> savedVariableProperties = copiedCustomScriptTask.getSavedVariableProperties();
        for (PropertyDescriptor propertyDescriptor : properties) {
            String propertyName = propertyDescriptor.getName();
            copiedPythonScript.setProperty(propertyName, savedVariableProperties.get(propertyName));
        }
    }

    @VisibleForTesting
    void updateGatesReferencingPhases(List<Phase> phasesToRestore, List<Phase> restoredPhases) {
        final Map<PlanItem, PlanItem> originToRestored = this.buildOriginToRestored(phasesToRestore, restoredPhases);
        this.scheduler.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                List<GateTask> gates = ReleaseEditor.this.tasks.findGatesWithStatus(TaskStatus.PLANNED, TaskStatus.PENDING, TaskStatus.IN_PROGRESS, TaskStatus.FAILED);
                for (GateTask gate : gates) {
                    Object object = ReleaseLock.of(gate);
                    synchronized (object) {
                        for (Dependency dependency : gate.getDependencies()) {
                            dependency = (Dependency)ReleaseEditor.this.repositoryService.read(dependency.getId());
                            Object target = dependency.getTarget();
                            if (!originToRestored.containsKey(target)) continue;
                            dependency.setTarget((PlanItem)((Object)originToRestored.get(target)));
                            ReleaseEditor.this.repositoryService.update((ConfigurationItem[])new Dependency[]{dependency});
                        }
                    }
                }
            }
        });
    }

    private Map<PlanItem, PlanItem> buildOriginToRestored(List<Phase> phasesToRestore, List<Phase> restoredPhases) {
        HashMap originToRestored = Maps.newHashMap();
        for (int i = 0; i < phasesToRestore.size(); ++i) {
            Phase originalPhase = phasesToRestore.get(i);
            Phase restoredPhase = restoredPhases.get(i);
            originToRestored.put(originalPhase, restoredPhase);
            List<Task> originalTasks = originalPhase.getAllTasks();
            List<Task> restoredTasks = restoredPhase.getAllTasks();
            for (int j = 0; j < originalTasks.size(); ++j) {
                originToRestored.put(originalTasks.get(j), restoredTasks.get(j));
            }
        }
        return originToRestored;
    }

    @VisibleForTesting
    void updateRelease(Release release, List<Phase> restoredPhases) {
        release.addBelow(release.getCurrentPhase().getId(), restoredPhases);
        release.setStatus(ReleaseStatus.PAUSED);
        this.repositoryService.update((ConfigurationItem[])new Release[]{release});
    }

    @VisibleForTesting
    void closePhase(Phase currentPhase) {
        ArrayList ciToUpdate = Lists.newArrayList();
        currentPhase.setStatus(PhaseStatus.SKIPPED);
        ciToUpdate.add(currentPhase);
        for (Task task : currentPhase.getAllTasks()) {
            if (task.isDone()) continue;
            task.setStatus(TaskStatus.SKIPPED);
            task.freezeVariables(new Changes(), true);
            ciToUpdate.add(task);
        }
        this.repositoryService.update(ciToUpdate.toArray(new ConfigurationItem[ciToUpdate.size()]));
        this.activityLog.log(Ids.releaseIdFrom(currentPhase.getId()), ReleaseActivities.PHASE_CLOSED.create(currentPhase.getTitle()));
    }
}

