/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.service;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ReleaseService {
    private Releases releases;
    private static final Function<PlanItem, String> TO_ID = new Function<PlanItem, String>(){

        public String apply(PlanItem planItem) {
            return planItem.getId();
        }
    };
    private static final Predicate<PlanItem> IS_DONE = new Predicate<PlanItem>(){

        public boolean apply(PlanItem planItem) {
            return planItem.isDone();
        }
    };

    @Autowired
    public ReleaseService(Releases releases) {
        this.releases = releases;
    }

    public List<Release> getDependencyTargetCandidates(String gateId) {
        List<Release> releaseList = this.releases.withStatus(ReleaseStatus.PLANNED, ReleaseStatus.IN_PROGRESS, ReleaseStatus.FAILED, ReleaseStatus.FAILING, ReleaseStatus.PAUSED);
        Release gateRelease = this.releases.findById(Ids.releaseIdFrom(gateId));
        releaseList.remove((Object)gateRelease);
        List<PlanItem> referencedCis = this.getReferencedCis(gateRelease);
        this.addReferencedReleases(releaseList, referencedCis);
        this.removeNotReferenceableCis(releaseList, referencedCis);
        return releaseList;
    }

    private List<PlanItem> getReferencedCis(Release gateRelease) {
        HashSet referencedItems = Sets.newHashSet();
        List<GateTask> gates = gateRelease.getAllGates();
        for (GateTask gate : gates) {
            List<Dependency> dependencies = gate.getDependencies();
            for (Dependency dependency : dependencies) {
                referencedItems.add(dependency.getTarget());
            }
        }
        return Lists.newArrayList((Iterable)referencedItems);
    }

    private void addReferencedReleases(List<Release> releaseList, List<PlanItem> referencedItems) {
        for (PlanItem referencedItem : referencedItems) {
            Release release = referencedItem.getRelease();
            if (releaseList.contains((Object)release)) continue;
            releaseList.add(release);
        }
    }

    private void removeNotReferenceableCis(List<Release> releaseList, List<PlanItem> referencedItems) {
        Predicate<PlanItem> isReferenced = this.isReferenced(referencedItems);
        Predicate acceptsPhase = Predicates.or((Predicate)Predicates.not(IS_DONE), isReferenced);
        Predicate acceptsTask = Predicates.or((Predicate)Predicates.not(IS_DONE), isReferenced);
        for (Release release : releaseList) {
            release.setPhases(Lists.newArrayList((Iterable)Collections2.filter(release.getPhases(), (Predicate)acceptsPhase)));
            for (Phase phase : release.getPhases()) {
                phase.setTasks(Lists.newArrayList((Iterable)Collections2.filter(phase.getTasks(), (Predicate)acceptsTask)));
            }
        }
    }

    private Predicate<PlanItem> isReferenced(List<PlanItem> referencedCis) {
        ImmutableSet ids = Multimaps.index(referencedCis, TO_ID).keySet();
        return new Predicate<PlanItem>((Set)ids){
            final /* synthetic */ Set val$ids;
            {
                this.val$ids = set;
            }

            public boolean apply(PlanItem planItem) {
                for (String id : this.val$ids) {
                    if (!id.startsWith(planItem.getId())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

