/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.views;

import com.xebialabs.deployit.plumbing.IdDeserializer;
import com.xebialabs.deployit.plumbing.IdSerializer;
import com.xebialabs.xlrelease.builder.ReleaseBuilder;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.views.Flag;
import java.util.Date;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonDeserialize;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class ReleaseForm {
    @JsonSerialize(using=IdSerializer.class)
    @JsonDeserialize(using=IdDeserializer.class)
    private String templateId;
    private Date scheduledStartDate;
    private Date dueDate;
    private String title;
    private String description;
    private String owner;
    private List<Variable> variables;
    private List<String> tags;
    private Flag flag = new Flag(FlagStatus.OK);
    private boolean calendarPublished;

    public boolean hasValidDates() {
        if (this.scheduledStartDate != null && this.dueDate != null) {
            return new DateTime((Object)this.scheduledStartDate).isBefore((ReadableInstant)new DateTime((Object)this.dueDate));
        }
        return true;
    }

    public boolean isFromTemplate() {
        return null != this.templateId;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public Date getScheduledStartDate() {
        return this.scheduledStartDate;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setScheduledStartDate(Date scheduledStartDate) {
        this.scheduledStartDate = scheduledStartDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public List<Variable> getVariables() {
        return this.variables;
    }

    public void setVariables(List<Variable> variables) {
        this.variables = variables;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public Flag getFlag() {
        return this.flag;
    }

    public void setFlag(Flag flag) {
        this.flag = flag;
    }

    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    public void setCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public Release toRelease() {
        return ReleaseBuilder.newRelease().withTitle(this.title).withDescription(this.description).withScheduledStartDate(this.scheduledStartDate).withDueDate(this.dueDate).withOwner(this.owner).withVariableValues(this.variables).withTags(this.tags).withFlagStatus(this.flag.getStatus()).withFlagComment(this.flag.getComment()).withCalendarPublished(this.calendarPublished).build();
    }
}

