/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.wro;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.xebialabs.xlrelease.Environment;
import com.xebialabs.xlrelease.wro.CustomProcessorsFactory;
import java.io.IOException;
import java.io.InputStream;
import ro.isdc.wro.manager.factory.BaseWroManagerFactory;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.factory.XmlModelFactory;
import ro.isdc.wro.model.group.Group;
import ro.isdc.wro.model.resource.Resource;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.util.Transformer;

public class CustomManagerFactory
extends BaseWroManagerFactory {
    public CustomManagerFactory() {
        final Environment environment = new Environment();
        this.addModelTransformer((Transformer)new Transformer<WroModel>(){

            public WroModel transform(WroModel input) throws Exception {
                for (Group group : input.getGroups()) {
                    for (Resource resource : group.getResources()) {
                        if (environment.isDevelopment()) {
                            resource.setMinimize(false);
                            resource.setUri("file:" + environment.getWebPath() + resource.getUri());
                            continue;
                        }
                        resource.setUri(CustomManagerFactory.this.getClassPathURI(resource));
                    }
                }
                return input;
            }
        });
    }

    protected ProcessorsFactory newProcessorsFactory() {
        return new CustomProcessorsFactory();
    }

    @VisibleForTesting
    String getClassPathURI(Resource resource) {
        if (Strings.isNullOrEmpty((String)resource.getUri())) {
            return "classpath:" + resource.getUri();
        }
        if (resource.getUri().charAt(0) == '/') {
            return "classpath:" + resource.getUri().substring(1);
        }
        return "classpath:" + resource.getUri();
    }

    protected WroModelFactory newModelFactory() {
        return new XmlModelFactory(){

            protected InputStream getModelResourceAsStream() throws IOException {
                return Resources.getResource((String)"wro.xml").openStream();
            }
        };
    }
}

