'use strict';

angular.module('xlrelease').controller('serversController', ['$scope', 'Backend', 'serverTitleFilter', 'Alerts', function ($scope, Backend, serverTitleFilter, Alerts) {
    var SERVERS_ENDPOINT = 'deployit/servers';

    var loadServers = function () {
        Backend.get(SERVERS_ENDPOINT).success(function (servers) {
            $scope.servers = servers;
        });
    };

    var getNewServer = function () {
        return {
            id: 'Configuration/Deployit/' + $scope.currentServer.title,
            username: $scope.currentServer.username,
            password: $scope.currentServer.password,
            url: $scope.currentServer.url,
            type: 'xlrelease.DeployitServerDefinition'
        };
    };

    loadServers();

    $scope.editNewServer = function () {
        $scope.currentServer = {};
        $scope.editMode = false;
    };

    $scope.save = function (dismissModal) {
        var currentServer = getNewServer();

        var onServerSaveError = function (data, status) {
            if (status === 400) {
                Alerts.clearError();
                $scope.serverAlreadyExists = true;
            }
        };

        if ($scope.editMode) {
            Backend.put(SERVERS_ENDPOINT + "/" + $scope.currentServer.id, currentServer)
                .success(loadServers).success(dismissModal)
                .error(onServerSaveError);
        } else {
            Backend.post(SERVERS_ENDPOINT, currentServer)
                .success(loadServers).success(dismissModal)
                .error(onServerSaveError);
        }
    };

    $scope.editServer = function (server) {
        $scope.editMode = true;
        $scope.currentServer = server;
        $scope.currentServer.title = serverTitleFilter(server.id);
    };

    $scope.deleteServer = function (server) {
        Backend.del(SERVERS_ENDPOINT + '/' + server.id).success(loadServers);
    };

    $scope.checkConnection = function () {
        $scope.checkingConnection = true;
        Backend.post('deployit/servers/check', getNewServer()).success(function (available) {
            $scope.unreachable = available === 'false';
            $scope.checkingConnection = false;
        });
    };

    $scope.resetServerInfo = function () {
        delete $scope.unreachable;
        delete $scope.checkingConnection;
        delete $scope.serverAlreadyExists;
    };
}]);
