angular.module('xlrelease').directive('pipelineLayout', function () {
    var WITH_MARGIN = true;

    function getReleaseWidth(release) {
        var elements = $(release).find('.phase,.gate,.arrow');
        var releaseWidth = _.reduce(elements, function (memo, element) {
            return memo + $(element).outerWidth(WITH_MARGIN);
        }, 0);

        var pipeline = $(release).find('.pipeline');
        releaseWidth += pipeline.outerWidth(WITH_MARGIN) - pipeline.width();

        return releaseWidth;
    }

    function updateReleasesWidth(element) {
        var releases = element.find('.release');

        var maxReleaseWidth = _.max(_.map(releases, getReleaseWidth));

        _.each(releases, function (release) {
            $(release).css({'min-width': maxReleaseWidth + 'px'});
        });
    }

    return function (scope, element) {
        scope.$watch('releases', function (releases) {
            if (releases) {
                scope.$evalAsync(function () {
                    updateReleasesWidth(element);
                });
            }
        }, false);
    };
});
