angular.module('xlrelease').controller('restartPhasesController', ['$scope', 'VariablesService', 'DeployitService', 'Backend', function ($scope, VariablesService, DeployitService, Backend) {

    $scope.releaseRestored = false;
    $scope.phaseRestartInProgress = false;

    $scope.restartPhasesFrom = function (phase) {
        $scope.phaseRestartInProgress = true;
        $scope.numberOfPhaseRestarted = $scope.restartPhases.restartables.length - _.indexOf($scope.restartPhases.restartables, phase);
        Backend.post('releases/' + $scope.release.id + '/restartPhasesFrom/' + phase.id).success(function (release) {
            $scope.phaseRestartInProgress = false;
            $scope.loadRelease();
            $scope.releaseRestored = true;
            loadVariables(release.variables);
        }).error(function () {
            $scope.phaseRestartInProgress = false;
            $scope.releaseRestored = false;
            $scope.dismiss();
        });
    };

    function loadVariables(variables) {
        $scope.variables = VariablesService.collectUsedVariables(variables);
        DeployitService.getAllEnvironmentsAndPackages($scope.variables, function (packages) {
            $scope.deployitPackages = packages;
        }, function (environments) {
            $scope.deployitEnvironments = environments;
        });
    }

    $scope.updateVariables = function (variables) {
        Backend.put('releases/' + $scope.release.id + '/variables', variables)
            .success($scope.loadRelease);
    };
}]);
