angular.module('xlrelease').filter('duration', function () {
    return function(durationInDays) {
        var nbDays = Math.floor(durationInDays);
        var remainingDuratinonInHours = moment.duration(durationInDays - nbDays, 'days').asHours();
        var nbHours = Math.floor(remainingDuratinonInHours);
        var remainingDuratinonInMinutes = moment.duration(remainingDuratinonInHours - nbHours, 'hours').asMinutes();
        var nbMinutes = Math.round(remainingDuratinonInMinutes);
        var formattedDuration = "";
        if (nbDays != 0) {
            formattedDuration += nbDays + 'd ';
        }
        if (nbHours != 0) {
            formattedDuration += nbHours + 'h ';
        }
        if (nbMinutes != 0 || formattedDuration === '') {
            formattedDuration += nbMinutes + 'm ';
        }

        return formattedDuration.replace(/^\s+|\s+$/g, '');
    }
});
