angular.module('xlrelease').factory('DeploymentProgressService', [function () {
    return {
        formatProgress: function (task, shortVersion) {
            if (task != null && angular.isDefined(task.deploymentStatus)) {
                if (task.deploymentStatus === 'COMPLETED') {
                    return 'Executed';
                }
                if (task.deploymentStatus === 'IN_PROGRESS' && task.totalStep === 0) {
                    return (shortVersion) ? 'Waiting' : 'Waiting to deploy';
                }
                var prefix = (task.deploymentStatus === 'IN_PROGRESS') ? 'Executing' : 'Failed at';
                var title = shortVersion ? 'step' : task.currentStepTitle;
                return   prefix + ' ' + title + ' ' + task.currentStep + '/' + task.totalStep;
            }
        }
    }
}]);

angular.module('xlrelease').filter('deploymentProgress', ['DeploymentProgressService', function (DeploymentProgressService) {
    return function (task) {
        return DeploymentProgressService.formatProgress(task, false);
    };
}]);

angular.module('xlrelease').filter('shortDeploymentProgress', ['DeploymentProgressService', function (DeploymentProgressService) {
    return function (task) {
        return DeploymentProgressService.formatProgress(task, true);
    };
}]);
