angular.module('xlrelease').directive('modal', ['$compile', '$parse', 'Modal', function ($compile, $parse, Modal) {
    function initModal(scope, modalElement, templateUrl, initFunction) {
        Modal.open();

        $parse(initFunction)(scope);

        scope.showModal = function () {
            modalElement.modal('show');

            angular.element(".modal-backdrop").on('click', function () {
                scope.$apply(scope.dismiss);
            });
        };

        $compile(modalElement.html('<div ng-include="' + templateUrl + '" onload="showModal()"></div>'))(scope);

        modalElement.on('keyup', function (e) {
            if (e.which === 27) {
                scope.$apply(scope.dismiss);
            }
        });

        modalElement.on('shown', function () {
            modalElement.find('input[autofocus]:first').trigger('focus');
        });
    }

    return {
        scope: true,
        link: function (scope, element, attrs) {
            var modalElement = angular.element('#modal');

            scope.dismiss = function () {
                $parse(attrs.onModalHide)(scope);
                Modal.close();
                modalElement.modal('hide');
                modalElement.off('keyup');
                modalElement.empty();
            };

            scope.$watch(attrs.openOn, function (triggerCondition) {
                if (angular.isDefined(triggerCondition) && triggerCondition) {
                    initModal(scope, modalElement, attrs.modal, attrs.init);
                }
            });

            element.on('click', function (event) {
                event.stopPropagation();
                scope.$apply(function () {
                    initModal(scope, modalElement, attrs.modal, attrs.init);
                });
            });
        }
    }
}]);

angular.module('xlrelease').factory('Modal', ['$q', function ($q) {
    var open = $q.defer();
    var close = $q.defer();

    return {
        open: function () {
            open.resolve('open');
            open = $q.defer();
        },
        close: function () {
            close.resolve('close');
            close = $q.defer();
        },
        withScope: function (scope) {
            var nextOpen = initPromise(open.promise, scope);
            var nextClose = initPromise(close.promise, scope);

            function initPromise(parentPromise, scope) {
                var defer = $q.defer();
                parentPromise.then(defer.resolve);
                scope.$on('$destroy', defer.reject);
                return defer.promise;
            }

            return {
                onNextOpen : function (callback) {
                    nextOpen.then(callback);
                    return this;
                },
                onNextClose: function (callback) {
                    nextClose.then(callback);
                    return this;
                }
            }
        }
    };
}]);
