'use strict';

angular.module('xlrelease').factory('RouterResolver', ['$q', '$location', '$route', 'Calendar', function ($q, $location, $route, Calendar) {
    return {
        initCurrentDate: function () {
            var URL_DATE_PATTERN = "^[0-9]{2}-[0-9]{4}$";
            var deferred = $q.defer();

            if (!$route.current.params.month || !$route.current.params.month.match(URL_DATE_PATTERN)) {
                $location.search({month: Calendar.currentMonth()}).replace();
                deferred.reject();
            } else {
                deferred.resolve();
            }

            return deferred.promise;
        }
    }
}]);
