'use strict';

angular.module('xlrelease').factory('SpecialDaysService', ['Backend', function (Backend) {

    function enhanceSpecialDay(specialDaysByDate, day) {
        var specialDay = specialDaysByDate[specialDayId(day)];
        if (specialDay) {
            day.color = specialDay.color;
            day.label = specialDay.label;
        }
    }

    function loadSpecialDays(firstDay, lastDay) {
        var range = {
            from: specialDayId(firstDay),
            to: specialDayId(lastDay)
        };

        return Backend.get('calendar/specialDays', { params: range });
    }

    function loadCalendarSpecialDays(weeks) {
        var firstDay = weeks[0].days[0];
        var lastDay = _.last(_.last(weeks).days);

        loadSpecialDays(firstDay, lastDay).success(function (specialDays) {
            var specialDaysByDate = _.indexBy(specialDays, 'date');

            _.each(weeks, function (week) {
                _.each(week.days, function (day) {
                    enhanceSpecialDay(specialDaysByDate, day);
                });
            });
        });
    }

    function loadTimelineSpecialDays(days) {
        var firstDay = days[0];
        var lastDay = _.last(days);

        loadSpecialDays(firstDay, lastDay).success(function (specialDays) {
            var specialDaysByDate = _.indexBy(specialDays, 'date');

            _.each(days, function (day) {
                enhanceSpecialDay(specialDaysByDate, day);
            });
        });
    }

    function specialDayId(day) {
        return day.fullDate.format('YYYYMMDD');
    }

    return {
        loadCalendarSpecialDays: loadCalendarSpecialDays,
        loadTimelineSpecialDays: loadTimelineSpecialDays,
        specialDayUrl: function specialDayUrl(day) {
            return 'calendar/specialDays/' + specialDayId(day);
        }
    }
}]);
