angular.module('xlrelease').factory('VariablesInterpolator', [function () {
    // Matches and captures ${...}, where "..." contains anything except '}'
    var VARIABLE_MATCHER = /(\$\{[^}]+\})/g;

    // Matches and captures all special chars in regexps in order to escape them.
    var ESCAPE_REGEXP_MATCHER = /([.*+?^=!:${}()|\[\]\/\\])/g;

    function toObject(variableViews) {
        var variables = {};

        _.each(variableViews, function (variableView) {
            variables[variableView.key] = variableView.value;
        });

        return variables
    }

    function escapeValues(variablesToEscape) {
        var variables = {};

        _.each(_.keys(variablesToEscape), function (variable) {
            variables[variable] = _.escape(variablesToEscape[variable]);
        });

        return variables;
    }

    function escapeRegExp(variableName) {
        return variableName.replace(ESCAPE_REGEXP_MATCHER, '\\$1');
    }

    function interpolate(text, variableValues, quoteReplacement) {
        var variables = _.uniq(text.match(VARIABLE_MATCHER));

        _.each(variables, function (variable) {
            var replacement = variableValues[variable] ? variableValues[variable] : variable;

            var regExp = new RegExp(escapeRegExp(variable), 'g');
            text = text.replace(regExp, quoteReplacement(replacement));
        });

        return text;
    }

    return {
        interpolateInText: function (variableViews, text) {
            var variableValues = toObject(variableViews);
            return interpolate(text, variableValues, _.identity);
        },
        interpolateInHtml: function (variableViews, text) {
            var variableValues = escapeValues(toObject(variableViews));

            function quoteHtmlReplacement(replacement) {
                return '<span class="variable">' + replacement + '</span>';
            }
            return interpolate(text, variableValues, quoteHtmlReplacement);
        }
    }
}]);
