/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plumbing.xml;

import com.google.common.base.Preconditions;
import com.thoughtworks.xstream.converters.Converter;
import com.xebialabs.deployit.plumbing.xml.XStreamCiConverterWithRepository;
import com.xebialabs.xltype.serialization.xstream.XStreamReaderWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.PostConstruct;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
@Provider
@Produces(value={"application/*+xml", "text/*+xml"})
@Consumes(value={"application/*+xml", "text/*+xml"})
public class SpringXStreamReaderWriter
extends XStreamReaderWriter
implements ApplicationContextAware {
    private ApplicationContext applicationContext;

    @PostConstruct
    protected void init() {
        if (this.applicationContext != null) {
            super.init();
            XStreamReaderWriter.registerConfigurationItemAliases();
        }
    }

    protected Converter constructConverter(Class<?> clazz) {
        try {
            Object bean = this.applicationContext.getBean(clazz);
            Preconditions.checkState((boolean)(bean instanceof Converter), (String)"[%s] should be a Converter", (Object[])new Object[]{bean});
            return (Converter)bean;
        }
        catch (BeansException be) {
            return super.constructConverter(clazz);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            Object object = super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
            return object;
        }
        catch (RuntimeException e) {
            XStreamCiConverterWithRepository.clear();
            throw e;
        }
        finally {
            XStreamCiConverterWithRepository.postProcess();
        }
    }
}

