/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.xebialabs.xlrelease.activity.ReleaseActivityFormatter;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PlanningFieldsComparator {
    private PlanItem original;

    public PlanningFieldsComparator(PlanItem original) {
        this.original = original;
    }

    public List<ActivityLogEntry> getScheduleStartDateLogs(Date updatedScheduleStartDate) {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)updatedScheduleStartDate)) {
            ReleaseActivity activity = this.getScheduledStartDateActivity(this.original);
            ActivityLogEntry activityLogEntry = this.createLogEntry(activity, this.original, this.original.getScheduledStartDate(), updatedScheduleStartDate);
            logEntries.add(activityLogEntry);
        }
        return logEntries;
    }

    public List<ActivityLogEntry> getDueDateLogs(Date updatedDueDate) {
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)updatedDueDate)) {
            ReleaseActivity activity = this.getDueDateActivity(this.original);
            ActivityLogEntry activityLogEntry = this.createLogEntry(activity, this.original, this.original.getDueDate(), updatedDueDate);
            logEntries.add(activityLogEntry);
        }
        return logEntries;
    }

    private ReleaseActivity getScheduledStartDateActivity(PlanItem planItem) {
        if (planItem instanceof Release) {
            return ReleaseActivity.RELEASE_SCHEDULED_START_DATE_UPDATED;
        }
        if (planItem instanceof Phase) {
            return ReleaseActivity.PHASE_SCHEDULED_START_DATE_UPDATED;
        }
        return ReleaseActivity.TASK_SCHEDULED_START_DATE_UPDATED;
    }

    private ReleaseActivity getDueDateActivity(PlanItem planItem) {
        if (planItem instanceof Release) {
            return ReleaseActivity.RELEASE_DUE_DATE_UPDATED;
        }
        if (planItem instanceof Phase) {
            return ReleaseActivity.PHASE_DUE_DATE_UPDATED;
        }
        return ReleaseActivity.TASK_DUE_DATE_UPDATED;
    }

    private ActivityLogEntry createLogEntry(ReleaseActivity activity, PlanItem planItem, Date originalDate, Date updatedDate) {
        if (planItem instanceof Release) {
            return activity.create(ReleaseActivityFormatter.formatDate(originalDate), ReleaseActivityFormatter.formatDate(updatedDate));
        }
        return activity.create(planItem.getTitle(), ReleaseActivityFormatter.formatDate(originalDate), ReleaseActivityFormatter.formatDate(updatedDate));
    }
}

