/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.activity;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.activity.ReleaseActivityFormatter;
import com.xebialabs.xlrelease.activity.ReleaseVariablesComparator;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.views.ReleaseForm;
import java.util.ArrayList;
import java.util.List;

public class ReleaseFieldsComparator {
    private Release original;
    private ReleaseForm updated;
    private UserProfiles userProfiles;

    public ReleaseFieldsComparator(Release original, ReleaseForm updated, UserProfiles userProfiles) {
        this.original = original;
        this.updated = updated;
        this.userProfiles = userProfiles;
    }

    public List<ActivityLogEntry> getLogs() {
        ActivityLogEntry variablesLog;
        ArrayList logEntries = Lists.newArrayList();
        if (!Objects.equal((Object)this.original.getTitle(), (Object)this.updated.getTitle())) {
            logEntries.add(ReleaseActivity.RELEASE_TITLE_UPDATED.create(this.original.getTitle(), this.updated.getTitle()));
        }
        if (!Objects.equal((Object)this.original.getDescription(), (Object)this.updated.getDescription())) {
            logEntries.add(ReleaseActivity.RELEASE_DESCRIPTION_UPDATED.create(this.original.getDescription(), this.updated.getDescription()));
        }
        if (!Objects.equal((Object)this.original.getDueDate(), (Object)this.updated.getDueDate())) {
            logEntries.add(ReleaseActivity.RELEASE_DUE_DATE_UPDATED.create(ReleaseActivityFormatter.formatDate(this.original.getDueDate()), ReleaseActivityFormatter.formatDate(this.updated.getDueDate())));
        }
        if (!Objects.equal((Object)this.original.getScheduledStartDate(), (Object)this.updated.getScheduledStartDate())) {
            logEntries.add(ReleaseActivity.RELEASE_SCHEDULED_START_DATE_UPDATED.create(ReleaseActivityFormatter.formatDate(this.original.getScheduledStartDate()), ReleaseActivityFormatter.formatDate(this.updated.getScheduledStartDate())));
        }
        if (!Objects.equal((Object)this.original.getOwner(), (Object)this.updated.getOwnerUsername())) {
            logEntries.add(ReleaseActivity.RELEASE_OWNER_UPDATED.create(ReleaseActivityFormatter.quoteUser(this.original.getOwner(), this.userProfiles), ReleaseActivityFormatter.quoteUser(this.updated.getOwnerUsername(), this.userProfiles)));
        }
        if (!Objects.equal(this.original.getTags(), this.updated.getTags())) {
            logEntries.add(ReleaseActivity.RELEASE_TAGS_UPDATED.create(this.updated.getTags() != null ? Sets.newHashSet(this.updated.getTags()) : null));
        }
        if (!this.original.isTemplate() && !Objects.equal((Object)((Object)this.original.getFlagStatus()), (Object)((Object)this.updated.getFlag().getStatus()))) {
            logEntries.add(ReleaseActivity.RELEASE_FLAG_STATUS_UPDATED.create(new Object[]{this.original.getFlagStatus(), this.updated.getFlag().getStatus()}));
        }
        if (!this.original.isTemplate() && !Objects.equal((Object)this.original.getFlagComment(), (Object)this.updated.getFlag().getComment())) {
            logEntries.add(ReleaseActivity.RELEASE_FLAG_COMMENT_UPDATED.create(this.original.getFlagComment(), this.updated.getFlag().getComment()));
        }
        if ((variablesLog = new ReleaseVariablesComparator(this.original.getVariableValues(), Variable.listToMap(this.updated.getVariables())).getLogEntry()) != null) {
            logEntries.add(variablesLog);
        }
        return logEntries;
    }
}

