/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.reflect.Descriptor;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.plumbing.id.IdType;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.domain.Configuration;
import com.xebialabs.xlrelease.repository.Configurations;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.ConfigurationView;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/configurations")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class ConfigurationResource {
    private Configurations configurations;
    private PermissionChecker permissions;

    @Autowired
    public ConfigurationResource(Configurations configurations, PermissionChecker permissions) {
        this.configurations = configurations;
        this.permissions = permissions;
    }

    @GET
    @Path(value="descriptors")
    public List<Descriptor> getConfigurationDescriptors() {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.configurations.findAllConfigurationDescriptors();
    }

    @GET
    public List<ConfigurationView> getConfigurationInstances(@QueryParam(value="anonymized") boolean anonymized) {
        if (anonymized) {
            return Lists.transform(this.configurations.findAll(), ConfigurationView.TO_ANONYMIZED_CONFIGURATION_VIEW);
        }
        this.permissions.check(PlatformPermissions.ADMIN);
        return Lists.transform(this.configurations.findAll(), ConfigurationView.TO_CONFIGURATION_VIEW);
    }

    @POST
    public ConfigurationView addConfigurationInstance(ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurations.create(configurationView);
        return (ConfigurationView)ConfigurationView.TO_CONFIGURATION_VIEW.apply((Object)configuration);
    }

    @GET
    @Path(value="{configurationInstanceId}")
    public ConfigurationView getConfigurationInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurations.findById(configurationInstanceId);
        return (ConfigurationView)ConfigurationView.TO_CONFIGURATION_VIEW.apply((Object)configuration);
    }

    @PUT
    @Path(value="{configurationInstanceId}")
    public ConfigurationView updateConfigurationInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId, ConfigurationView configurationView) {
        this.permissions.check(PlatformPermissions.ADMIN);
        Configuration configuration = this.configurations.updateWith(configurationInstanceId, configurationView);
        return (ConfigurationView)ConfigurationView.TO_CONFIGURATION_VIEW.apply((Object)configuration);
    }

    @DELETE
    @Path(value="{configurationInstanceId}")
    public void deleteConfigurationInstance(@IdParam(value=IdType.CONFIGURATION) @PathParam(value="configurationInstanceId") String configurationInstanceId) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.configurations.delete(configurationInstanceId);
    }
}

