/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.engine.api.dto.ConfigurationItemId;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.configuration.DeployitServerDefinition;
import com.xebialabs.xlrelease.repository.DeployitServers;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.DeployitService;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/deployit")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class DeployitResource {
    private DeployitServers deployitServers;
    private DeployitService deployitService;
    private PermissionChecker permissions;
    private static final Function<ConfigurationItemId, String> TO_PACKAGE_NAME = new Function<ConfigurationItemId, String>(){

        public String apply(ConfigurationItemId configurationItemId) {
            return configurationItemId.getId().replaceAll("^" + Metadata.ConfigurationItemRoot.APPLICATIONS.getRootNodeName() + "/", "");
        }
    };
    private static final Function<ConfigurationItemId, String> TO_ENVIRONMENT_NAME = new Function<ConfigurationItemId, String>(){

        public String apply(ConfigurationItemId configurationItemId) {
            return configurationItemId.getId().replaceAll("^" + Metadata.ConfigurationItemRoot.ENVIRONMENTS.getRootNodeName() + "/", "");
        }
    };

    @Autowired
    public DeployitResource(DeployitServers deployitServers, DeployitService deployitService, PermissionChecker permissions) {
        this.deployitServers = deployitServers;
        this.deployitService = deployitService;
        this.permissions = permissions;
    }

    @Path(value="/connectionStatus")
    @POST
    public boolean checkConnection(DeployitServerDefinition server) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.deployitService.checkConnection(server);
    }

    @Path(value="/servers")
    @GET
    public List<DeployitServerDefinition> getDeployitServers(@QueryParam(value="anonymized") boolean onlyIds) {
        if (onlyIds) {
            return Lists.transform(this.deployitServers.getServers(), DeployitServerDefinition.ANONYMIZE);
        }
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.deployitServers.getServers();
    }

    @Path(value="/servers")
    @POST
    public DeployitServerDefinition addServer(DeployitServerDefinition server) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.deployitServers.addServer(server);
    }

    @Path(value="/servers/{serverId:.+}")
    @PUT
    public DeployitServerDefinition updateServer(@PathParam(value="serverId") String serverId, DeployitServerDefinition server) {
        this.permissions.check(PlatformPermissions.ADMIN);
        return this.deployitServers.updateServer(serverId, server);
    }

    @Path(value="/servers/{ID:.+}")
    @DELETE
    public void deleteServer(@PathParam(value="ID") String id) {
        this.permissions.check(PlatformPermissions.ADMIN);
        this.deployitServers.deleteServer(id);
    }

    @Path(value="/servers/{serverId:.+}/packages")
    @GET
    public List<String> getDeployitPackages(@PathParam(value="serverId") String serverId) {
        List<ConfigurationItemId> packageIds = this.deployitService.getPackagesIds(this.deployitServers.findById(serverId));
        return Lists.transform(packageIds, TO_PACKAGE_NAME);
    }

    @Path(value="/servers/{serverId:.+}/environments")
    @GET
    public List<String> getDeployitEnvironments(@PathParam(value="serverId") String serverId) {
        List<ConfigurationItemId> environmentIds = this.deployitService.getEnvironmentsIds(this.deployitServers.findById(serverId));
        return Lists.transform(environmentIds, TO_ENVIRONMENT_NAME);
    }

    @Path(value="/packages")
    @GET
    public List<String> getDeployitPackages() throws InterruptedException {
        List<DeployitServerDefinition> servers = this.deployitServers.getServers();
        List<ConfigurationItemId> ids = this.deployitService.getPackagesIds(servers);
        return Lists.transform(ids, TO_PACKAGE_NAME);
    }

    @Path(value="/environments")
    @GET
    public List<String> getDeployitEnvironments() throws InterruptedException {
        List<DeployitServerDefinition> servers = this.deployitServers.getServers();
        List<ConfigurationItemId> ids = this.deployitService.getEnvironmentsIds(servers);
        return Lists.transform(ids, TO_ENVIRONMENT_NAME);
    }
}

