/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.repository.Dependencies;
import com.xebialabs.xlrelease.repository.GateConditions;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ReleaseService;
import com.xebialabs.xlrelease.views.DependencyView;
import com.xebialabs.xlrelease.views.GateConditionView;
import com.xebialabs.xlrelease.views.ReleaseView;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/gates")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class GatesResource {
    private GateConditions conditions;
    private Dependencies dependencies;
    private Releases releases;
    private ReleaseService releaseService;
    private PermissionChecker permissions;
    private Tasks tasks;

    @Autowired
    public GatesResource(GateConditions conditions, Dependencies dependencies, Releases releases, ReleaseService releaseService, PermissionChecker permissions, Tasks tasks) {
        this.conditions = conditions;
        this.dependencies = dependencies;
        this.releases = releases;
        this.releaseService = releaseService;
        this.permissions = permissions;
        this.tasks = tasks;
    }

    public GatesResource() {
    }

    @PUT
    @Path(value="conditions/{conditionId}")
    @Synchronized
    public GateConditionView updateCondition(@PathParam(value="conditionId") @IdParam @ReleaseIdHolder String conditionId, GateConditionView conditionView) {
        Release release = this.releases.findById(Ids.releaseIdFrom(conditionId));
        if (release.isTemplate()) {
            this.permissions.check(XLReleasePermissions.EDIT_TEMPLATE, release.getId());
        } else {
            this.permissions.checkIsAllowedToWorkOnTask(Ids.getParentId(conditionId));
            GateCondition previousCondition = this.conditions.findById(conditionId);
            if (!Objects.equal((Object)previousCondition.getTitle(), (Object)conditionView.toCondition().getTitle())) {
                this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(conditionId));
            }
        }
        return new GateConditionView(this.conditions.update(conditionId, conditionView.toCondition()));
    }

    @POST
    @Path(value="{gateId}/conditions")
    @Synchronized
    public GateConditionView createCondition(@PathParam(value="gateId") @IdParam @ReleaseIdHolder String gateId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom(gateId));
        GateCondition gateCondition = this.conditions.create(gateId);
        return new GateConditionView(gateCondition);
    }

    @DELETE
    @Path(value="conditions/{conditionId}")
    @Synchronized
    public void deleteCondition(@PathParam(value="conditionId") @IdParam @ReleaseIdHolder String conditionId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom(conditionId));
        Task task = this.tasks.findById(Ids.getParentId(conditionId));
        Preconditions.checkArgument((!task.isInProgress() ? 1 : 0) != 0, (Object)"Can't delete a dependency on a running task.");
        this.conditions.delete(conditionId);
    }

    @POST
    @Path(value="{gateId}/dependencies")
    @Synchronized
    public DependencyView addDependency(@PathParam(value="gateId") @IdParam @ReleaseIdHolder String gateId, DependencyView dependencyView) {
        this.permissions.checkEditTask(Ids.releaseIdFrom(gateId));
        this.permissions.checkView(Ids.releaseIdFrom(dependencyView.toTargetId()));
        Task gate = this.tasks.findById(gateId);
        Preconditions.checkArgument((!gate.isInProgress() ? 1 : 0) != 0, (Object)"Can't add a dependency on a running task.");
        Dependency dependency = this.dependencies.create(gateId, dependencyView.toTargetId());
        return new DependencyView(dependency);
    }

    @GET
    @Path(value="{gateId}/dependency-target-candidates")
    @Synchronized
    public List<ReleaseView> getDependencyTargetCandidates(@PathParam(value="gateId") @IdParam @ReleaseIdHolder String gateId) {
        List<Release> dependencyTargetCandidates = this.releaseService.getDependencyTargetCandidates(gateId);
        Collections.sort(dependencyTargetCandidates, PlanItem.BY_TITLE);
        List<Release> visible = this.permissions.filter(dependencyTargetCandidates, XLReleasePermissions.VIEW_RELEASE);
        return Lists.transform(visible, ReleaseView.TO_RELEASE_VIEW);
    }
}

