/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Phases;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.views.PhaseForm;
import com.xebialabs.xlrelease.views.PhaseFullView;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/phases")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class PhaseResource {
    private Phases phases;
    private PermissionChecker permissionChecker;
    private UserProfiles userProfiles;

    @Autowired
    public PhaseResource(Phases phases, PermissionChecker permissionChecker, UserProfiles userProfiles) {
        this.phases = phases;
        this.permissionChecker = permissionChecker;
        this.userProfiles = userProfiles;
    }

    public PhaseResource() {
    }

    @PUT
    @Path(value="{phaseId}")
    @Synchronized
    public PhaseFullView update(@PathParam(value="phaseId") @IdParam @ReleaseIdHolder String phaseId, PhaseForm phaseForm) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom(phaseId));
        Phase phase = this.phases.update(phaseId, phaseForm);
        return new PhaseFullView(phase, this.userProfiles);
    }

    @DELETE
    @Path(value="{phaseId}")
    @Synchronized
    public void deletePhase(@PathParam(value="phaseId") @IdParam @ReleaseIdHolder String phaseId) {
        this.permissionChecker.checkEdit(Ids.releaseIdFrom(phaseId));
        this.phases.delete(phaseId);
    }
}

