/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.core.api.dto.RolePermissions;
import com.xebialabs.deployit.core.api.dto.RolePrincipals;
import com.xebialabs.deployit.core.rest.api.SecurityResource;
import com.xebialabs.deployit.engine.api.security.Role;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.views.RolePermissionsView;
import com.xebialabs.xlrelease.views.RolesPermissionsView;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/roles/permissions")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class RolePermissionsResource {
    private static final String GLOBAL = "global";
    private SecurityResource securityResource;
    private PermissionChecker permissionChecker;

    @Autowired
    public RolePermissionsResource(SecurityResource securityResource, PermissionChecker permissionChecker) {
        this.securityResource = securityResource;
        this.permissionChecker = permissionChecker;
    }

    @GET
    @Path(value="/global")
    public RolesPermissionsView getGlobalRolePermissions() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        ImmutableMap map = Maps.uniqueIndex((Iterable)this.securityResource.readRolePermissions(GLOBAL), (Function)new Function<RolePermissions, Integer>(){

            public Integer apply(RolePermissions input) {
                return input.getRole().getId();
            }
        });
        ArrayList roles = Lists.newArrayList();
        for (RolePrincipals rolePrincipals : this.securityResource.readRolePrincipals()) {
            Role role = rolePrincipals.getRole();
            RolePermissions rolePermissions = (RolePermissions)map.get(role.getId());
            if (rolePermissions != null) {
                roles.add(rolePermissions);
                continue;
            }
            roles.add(new RolePermissions(role, (List)Lists.newArrayList()));
        }
        return new RolesPermissionsView(roles, XLReleasePermissions.getGlobalPermissions());
    }

    @PUT
    @Path(value="/global")
    public void setGlobalRolePermissions(List<RolePermissionsView> rolePermissionsViews) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        List permissions = Lists.transform(rolePermissionsViews, (Function)new Function<RolePermissionsView, RolePermissions>(){

            public RolePermissions apply(RolePermissionsView input) {
                return input.toRolePermissions();
            }
        });
        this.securityResource.writeRolePermissions(GLOBAL, permissions);
    }
}

