/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.xebialabs.deployit.core.rest.api.PermissionResource;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.xlrelease.content.Templates;
import com.xebialabs.xlrelease.repository.UserProfiles;
import java.util.Collection;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/security")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class SecurityResource {
    private PermissionResource permissionResource;
    private UserProfiles userProfiles;
    private Templates templates;

    @Autowired
    public SecurityResource(PermissionResource permissionResource, UserProfiles userProfiles, Templates templates) {
        this.permissionResource = permissionResource;
        this.userProfiles = userProfiles;
        this.templates = templates;
    }

    @GET
    public Map<String, Collection<String>> getGlobalPermissions() {
        String username = Permissions.getAuthenticatedUserName();
        boolean newUser = !this.userProfiles.exists(username);
        this.userProfiles.ensureCreated(username);
        if (newUser) {
            this.templates.startWelcomeRelease(username);
        }
        return this.permissionResource.getMyGrantedPermissions();
    }
}

