/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimaps;
import com.xebialabs.deployit.plugin.api.reflect.PropertyDescriptor;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plumbing.id.IdParam;
import com.xebialabs.deployit.repository.RepositoryService;
import com.xebialabs.deployit.security.PermissionDeniedException;
import com.xebialabs.deployit.security.Permissions;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.RoleService;
import com.xebialabs.deployit.util.PasswordEncrypter;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.customscripts.PythonScriptDefinitions;
import com.xebialabs.xlrelease.domain.Comment;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.PythonScriptDefinition;
import com.xebialabs.xlrelease.domain.Release;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.filters.TaskFilter;
import com.xebialabs.xlrelease.repository.Comments;
import com.xebialabs.xlrelease.repository.Ids;
import com.xebialabs.xlrelease.repository.Releases;
import com.xebialabs.xlrelease.repository.Tasks;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.security.XLReleasePermissions;
import com.xebialabs.xlrelease.service.ExecutionService;
import com.xebialabs.xlrelease.service.TaskService;
import com.xebialabs.xlrelease.user.User;
import com.xebialabs.xlrelease.views.CommentView;
import com.xebialabs.xlrelease.views.ReleaseTasks;
import com.xebialabs.xlrelease.views.TaskForm;
import com.xebialabs.xlrelease.views.TaskFullView;
import com.xebialabs.xlrelease.views.TasksFilters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/tasks")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class TaskResource {
    private static final Predicate<Team> WITHOUT_TEMPLATE_OWNER = new Predicate<Team>(){

        public boolean apply(Team team) {
            return !team.getTeamName().equals("Template Owner");
        }
    };
    private Releases releases;
    private Tasks tasks;
    private Comments comments;
    private RepositoryService repositoryService;
    private PermissionChecker permissions;
    private ExecutionService executionService;
    private PythonScriptDefinitions pythonScriptDefinitions;
    private RoleService roleService;
    private UserProfiles userProfiles;
    private TaskService taskService;
    private static final Function<Task, Release> TO_RELEASE = new Function<Task, Release>(){

        public Release apply(Task task) {
            return task.getPhase().getRelease();
        }
    };

    @Autowired
    public TaskResource(Releases releases, Tasks tasks, Comments comments, RepositoryService repositoryService, PermissionChecker permissions, ExecutionService executionService, PythonScriptDefinitions customScriptTypes, RoleService roleService, UserProfiles userProfiles, TaskService taskService) {
        this.releases = releases;
        this.tasks = tasks;
        this.comments = comments;
        this.repositoryService = repositoryService;
        this.permissions = permissions;
        this.executionService = executionService;
        this.pythonScriptDefinitions = customScriptTypes;
        this.roleService = roleService;
        this.userProfiles = userProfiles;
        this.taskService = taskService;
    }

    public TaskResource() {
    }

    @POST
    @Path(value="{containerId}")
    @Synchronized
    public TaskFullView addTask(@PathParam(value="containerId") @IdParam @ReleaseIdHolder String containerId, TaskForm taskForm) {
        String releaseId = Ids.releaseIdFrom(containerId);
        this.permissions.checkView(releaseId);
        this.permissions.checkEdit(releaseId);
        this.permissions.checkEditTask(releaseId);
        Task task = this.tasks.create(containerId, taskForm.toTask());
        return new TaskFullView(task, this.userProfiles);
    }

    @GET
    @Path(value="{taskId: [^/]+}")
    public TaskFullView getTask(@PathParam(value="taskId") @IdParam String taskId) {
        String username = Permissions.getAuthenticatedUserName();
        List userRoles = this.roleService.getRolesFor(username);
        Task task = this.tasks.findById(taskId);
        if (!this.allowedToSeeTask(task, username, userRoles)) {
            throw new PermissionDeniedException("Not allowed to get this task");
        }
        return new TaskFullView(task, this.userProfiles);
    }

    @POST
    @Path(value="search")
    public List<ReleaseTasks> getTasksByRelease(TasksFilters tasksFilters) {
        final String username = Permissions.getAuthenticatedUserName();
        List<Release> activeReleases = this.releases.active();
        final List userRoles = this.roleService.getRolesFor(username);
        TaskFilter taskFilter = new TaskFilter(tasksFilters, this.userProfiles);
        ArrayList tasks = taskFilter.filter(username, userRoles, activeReleases);
        Predicate<Task> canSeeTaskPredicate = new Predicate<Task>(){

            public boolean apply(Task candidate) {
                return TaskResource.this.allowedToSeeTask(candidate, username, userRoles);
            }
        };
        tasks = Lists.newArrayList((Iterable)Collections2.filter(tasks, (Predicate)canSeeTaskPredicate));
        ImmutableListMultimap tasksByRelease = Multimaps.index((Iterable)tasks, TO_RELEASE);
        ArrayList releaseTasks = Lists.newArrayList((Iterable)Collections2.transform(tasksByRelease.asMap().entrySet(), TaskResource.toReleaseTasks(this.userProfiles)));
        Collections.sort(releaseTasks, ReleaseTasks.BY_TITLE);
        return releaseTasks;
    }

    private static Function<Map.Entry<Release, Collection<Task>>, ReleaseTasks> toReleaseTasks(final UserProfiles userProfiles) {
        return new Function<Map.Entry<Release, Collection<Task>>, ReleaseTasks>(){

            public ReleaseTasks apply(Map.Entry<Release, Collection<Task>> entry) {
                return new ReleaseTasks(entry.getKey(), Lists.newArrayList((Iterable)entry.getValue()), userProfiles);
            }
        };
    }

    @POST
    @Path(value="{taskId: [^/]+}/complete")
    @Synchronized
    public Response completeTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Task task = this.tasks.findById(taskId);
        if (task.isPlanned()) {
            this.checkIsStatusCompletableInAdvance(taskId);
            this.checkReleaseIsInProgress(Ids.releaseIdFrom(taskId));
            this.executionService.markTaskAsDone(TaskStatus.COMPLETED_IN_ADVANCE, taskId, comment.getText());
        } else {
            this.checkIsStatusUpdatable(taskId, "complete");
            this.executionService.markTaskAsDone(TaskStatus.COMPLETED, taskId, comment.getText());
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="{taskId: [^/]+}/skip")
    @Synchronized
    public Response skipTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Task task = this.tasks.findById(taskId);
        if (task.isPlanned()) {
            this.checkIsTaskSkippableInAdvance(taskId);
            this.checkReleaseIsInProgress(Ids.releaseIdFrom(taskId));
            this.executionService.markTaskAsDone(TaskStatus.SKIPPED_IN_ADVANCE, taskId, comment.getText());
        } else {
            this.checkIsTaskSkippable(taskId);
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory when skipping a task.");
            this.executionService.markTaskAsDone(TaskStatus.SKIPPED, taskId, comment.getText());
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="{taskId: [^/]+}/fail")
    @Synchronized
    public Response failTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory when failing a task.");
        Preconditions.checkArgument((!this.isScriptOrCustomScriptTask(taskId) ? 1 : 0) != 0, (Object)"Script tasks can't be failed, they can be aborted");
        this.checkIsStatusUpdatable(taskId, "fail");
        this.executionService.fail(taskId, comment.getText());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="{taskId: [^/]+}/abort")
    @Synchronized
    public Response abortTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory when aborting a task.");
        Preconditions.checkArgument((boolean)this.isScriptOrCustomScriptTask(taskId), (Object)"Only script tasks can be aborted");
        this.checkIsTaskCancellable(taskId);
        this.executionService.abortTask(taskId, comment.getText());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="{taskId: [^/]+}/retry")
    @Synchronized
    public Response retryTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.checkIsReleaseOwner(Ids.releaseIdFrom(taskId));
        this.checkIsTaskRetriable(taskId);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory when retrying a task.");
        this.executionService.retry(taskId, comment.getText());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="{taskId: [^/]+}/startNow")
    @Synchronized
    public Response startNow(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(taskId));
        this.executionService.startPendingTask(taskId, comment.getText());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @POST
    @Path(value="{taskId: [^/]+}/reopen")
    @Synchronized
    public Response reopenTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView comment) {
        this.permissions.hasPermission(XLReleasePermissions.VIEW_RELEASE, Ids.releaseIdFrom(taskId));
        this.permissions.check(XLReleasePermissions.EDIT_RELEASE_TASK, Ids.releaseIdFrom(taskId));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)comment.getText()) ? 1 : 0) != 0, (Object)"Comment is mandatory when reopening a task.");
        this.checkIsTaskReopenabe(taskId);
        this.checkReleaseIsInProgress(Ids.releaseIdFrom(taskId));
        this.executionService.reopenTask(taskId, comment.getText());
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @GET
    @Path(value="{taskId: [^/]+}/comments")
    public List<CommentView> getCommentsOfTask(@PathParam(value="taskId") @IdParam String taskId) {
        Task task = (Task)this.repositoryService.read(taskId);
        return Lists.transform(task.getComments(), CommentView.toCommentView(this.userProfiles));
    }

    @GET
    @Path(value="{taskId: [^/]+}/teams/assignable")
    public Collection<Team> getAssignableTeams(@PathParam(value="taskId") @IdParam String taskId) {
        this.permissions.checkEditOrReassignTask(Ids.releaseIdFrom(taskId));
        Release release = this.releases.containingTask(taskId);
        return Collections2.filter(release.getTeams(), WITHOUT_TEMPLATE_OWNER);
    }

    @POST
    @Path(value="{taskId: [^/]+}/comments")
    @Synchronized
    public CommentView addComment(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, CommentView commentView) {
        this.permissions.checkIsAllowedToWorkOnTask(taskId);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)commentView.getText()) ? 1 : 0) != 0, (Object)"A comment is required.");
        Comment comment = this.comments.create(taskId, commentView.getText(), User.AUTHENTICATED_USER, true);
        return new CommentView(comment, this.userProfiles);
    }

    @PUT
    @Path(value="{taskId: [^/]+}")
    @Synchronized
    public TaskFullView updateTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, TaskFullView updatedTask) {
        Preconditions.checkArgument((updatedTask.getFlag().getStatus() != null ? 1 : 0) != 0, (Object)"Flag status is required.");
        this.decryptCustomFieldsPasswords(updatedTask);
        this.permissions.checkEditTask(Ids.releaseIdFrom(taskId));
        Task task = this.tasks.findById(taskId);
        boolean ownerHasBeenReassigned = updatedTask.ownerHasBeenReassigned(task);
        boolean teamHasBeenReassigned = updatedTask.teamHasBeenReassigned(task);
        String previousOwner = task.getOwner();
        if (ownerHasBeenReassigned || teamHasBeenReassigned) {
            this.permissions.checkReassignTask(Ids.releaseIdFrom(taskId));
        }
        this.tasks.updateTaskWith(task, updatedTask);
        if (ownerHasBeenReassigned) {
            this.taskService.notifyOwnerReassignment(task, previousOwner);
        }
        return new TaskFullView(task, this.userProfiles);
    }

    @PUT
    @Path(value="{taskId: [^/]+}/owner")
    @Synchronized
    public void reassignToOwner(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, TaskFullView updatedTask) {
        String newOwner;
        this.permissions.checkReassignTask(Ids.releaseIdFrom(taskId));
        Task task = this.tasks.findById(taskId);
        String previousOwner = task.getOwner();
        String string = newOwner = updatedTask != null ? updatedTask.getOwnerUsername() : null;
        if (!Objects.equal((Object)newOwner, (Object)previousOwner)) {
            this.tasks.reassignToOwner(task, newOwner);
            this.taskService.notifyOwnerReassignment(task, previousOwner);
        }
    }

    @DELETE
    @Path(value="{taskId: [^/]+}/owner")
    @Synchronized
    public void removeOwner(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId) {
        this.reassignToOwner(taskId, null);
    }

    @PUT
    @Path(value="{taskId: [^/]+}/team")
    @Synchronized
    public void reassignToTeam(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId, TaskFullView updatedTask) {
        String newTeam;
        this.permissions.checkReassignTask(Ids.releaseIdFrom(taskId));
        Task task = this.tasks.findById(taskId);
        String previousTeam = task.getTeam();
        String string = newTeam = updatedTask != null ? updatedTask.getTeam() : null;
        if (!Objects.equal((Object)newTeam, (Object)previousTeam)) {
            this.tasks.reassignToTeam(task, newTeam);
        }
    }

    @DELETE
    @Path(value="{taskId: [^/]+}/team")
    @Synchronized
    public void removeTeam(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId) {
        this.reassignToTeam(taskId, null);
    }

    @DELETE
    @Path(value="{taskId: [^/]+}")
    @Synchronized
    public void deleteTask(@PathParam(value="taskId") @IdParam @ReleaseIdHolder String taskId) {
        this.permissions.checkEditTask(Ids.releaseIdFrom(taskId));
        this.permissions.checkEdit(Ids.releaseIdFrom(taskId));
        this.tasks.delete(taskId);
    }

    @POST
    @Path(value="poll")
    public List<TaskFullView> poll(@QueryParam(value="id") @IdParam List<String> taskIds) {
        List<Task> taskList = this.tasks.findById(taskIds);
        return Lists.transform(taskList, TaskFullView.toTaskFullView(this.userProfiles));
    }

    @GET
    @Path(value="python-script-definitions")
    public Collection<PythonScriptDefinition> getPythonScriptDefinitions() {
        return Collections2.transform(this.pythonScriptDefinitions.getTypes(), PythonScriptDefinition.TO_METADATA);
    }

    @GET
    @Path(value="python-script-definitions/{scriptDefinitionType}")
    public PythonScriptDefinition getCustomScriptProperties(@PathParam(value="scriptDefinitionType") String scriptDefinitionType) {
        return new PythonScriptDefinition(Type.valueOf((String)scriptDefinitionType));
    }

    private boolean isScriptOrCustomScriptTask(String taskId) {
        Task task = this.tasks.findById(taskId);
        return task instanceof ScriptTask || task instanceof CustomScriptTask;
    }

    private void checkIsStatusUpdatable(String taskId, String action) {
        Task task = this.tasks.findById(taskId);
        if (!this.canUpdateInProgressStatus(task)) {
            throw new IllegalArgumentException("You can not " + action + " a task that is : not in progress, automated, or unassigned");
        }
    }

    private void checkIsStatusCompletableInAdvance(String taskId) {
        Task task = this.tasks.findById(taskId);
        boolean isAutomated = (Boolean)task.getProperty("automated");
        if (!this.canUpdatePlannedStatus(task) || isAutomated) {
            throw new IllegalArgumentException("You can not complete in advance a task that is : not planned or unassigned or automated");
        }
    }

    private void checkIsTaskSkippable(String taskId) {
        Task task = this.tasks.findById(taskId);
        if (!this.canUpdateInProgressStatus(task) && !this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not skip a task that is : (in progress and automated or unassigned) or (failed and not automated or unassigned)");
        }
    }

    private void checkIsTaskSkippableInAdvance(String taskId) {
        Task task = this.tasks.findById(taskId);
        if (!this.canUpdatePlannedStatus(task)) {
            throw new IllegalArgumentException("You can not skip in advance a task that is : not planned or unassigned");
        }
    }

    private void checkIsTaskRetriable(String taskId) {
        Task task = this.tasks.findById(taskId);
        if (!this.canUpdateFailedStatus(task)) {
            throw new IllegalArgumentException("You can not retry a task that is : failed and not automated or unassigned");
        }
    }

    private void checkIsTaskCancellable(String taskId) {
        Task task = this.tasks.findById(taskId);
        Preconditions.checkArgument((task instanceof ScriptTask || task instanceof CustomScriptTask ? 1 : 0) != 0, (Object)"Only ScriptTask or CustomScriptTask may be cancelled");
        Preconditions.checkState((boolean)task.isInProgress(), (Object)"Only running tasks may be cancelled");
    }

    private void checkIsTaskReopenabe(String taskId) {
        Task task = this.tasks.findById(taskId);
        if (!task.isDoneInAdvance()) {
            throw new IllegalArgumentException("You can not reopen a task that is not done in advance");
        }
    }

    private boolean canUpdateInProgressStatus(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        return task.isInProgress() && !isAutomated && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdatePlannedStatus(Task task) {
        return task.isPlanned() && (task.hasOwner() || task.hasTeam());
    }

    private boolean canUpdateFailedStatus(Task task) {
        boolean isAutomated = (Boolean)task.getProperty("automated");
        return task.isFailed() && (isAutomated || task.hasOwner() || task.hasTeam());
    }

    private void decryptCustomFieldsPasswords(TaskFullView updatedTask) {
        if (Strings.isNullOrEmpty((String)updatedTask.getScriptDefinitionType())) {
            return;
        }
        PasswordEncrypter passwordEncrypter = PasswordEncrypter.getInstance();
        PythonScriptDefinition pythonScriptDefinition = new PythonScriptDefinition(Type.valueOf((String)updatedTask.getScriptDefinitionType()));
        for (PropertyDescriptor inputProperty : pythonScriptDefinition.getInputProperties()) {
            if (!inputProperty.isPassword()) continue;
            String propertyName = inputProperty.getName();
            String encryptedPassword = (String)updatedTask.getInputProperties().get(propertyName);
            String decryptedPassword = passwordEncrypter.ensureDecrypted(encryptedPassword);
            updatedTask.getInputProperties().put(propertyName, decryptedPassword);
        }
    }

    private boolean allowedToSeeTask(Task task, String username, List<Role> userRoles) {
        Release release = task.getRelease();
        return this.permissions.hasPermission(XLReleasePermissions.VIEW_RELEASE, release.getId()) || task.hasOwner(username) || release.getTeamsOf(username, userRoles).contains(task.getTeam());
    }

    private void checkReleaseIsInProgress(String releaseId) {
        Release release = this.releases.findById(releaseId);
        Preconditions.checkState((boolean)release.isInProgress(), (String)"The release '%s' must be in progress.", (Object[])new Object[]{release.getTitle()});
    }
}

