/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.api;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.engine.spi.exception.DeployitException;
import com.xebialabs.deployit.engine.spi.exception.HttpResponseCodeResult;
import com.xebialabs.deployit.jcr.RuntimeRepositoryException;
import com.xebialabs.deployit.security.JcrUserService;
import com.xebialabs.deployit.security.permission.PlatformPermissions;
import com.xebialabs.xlrelease.configuration.UserProfile;
import com.xebialabs.xlrelease.content.Templates;
import com.xebialabs.xlrelease.repository.UserProfiles;
import com.xebialabs.xlrelease.security.PermissionChecker;
import com.xebialabs.xlrelease.service.JcrUsers;
import com.xebialabs.xlrelease.views.UserAccount;
import com.xebialabs.xlrelease.views.UserView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.TreeSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.jackrabbit.api.security.user.AuthorizableExistsException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Path(value="/users")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Controller
public class UserAccountResource {
    private JcrUserService jcrUserService;
    private JcrUsers jcrUsers;
    private UserProfiles userProfiles;
    private PermissionChecker permissionChecker;
    private Templates templates;
    private static final Function<UserProfile, String> BY_NAME = new Function<UserProfile, String>(){

        public String apply(UserProfile profile) {
            return this.extractName(profile.getId());
        }

        private String extractName(String id) {
            return id.replace(UserProfiles.ROOT + "/", "");
        }
    };

    @Autowired
    public UserAccountResource(JcrUserService jcrUserService, JcrUsers jcrUsers, UserProfiles userProfiles, PermissionChecker permissionChecker, Templates templates) {
        this.jcrUserService = jcrUserService;
        this.jcrUsers = jcrUsers;
        this.userProfiles = userProfiles;
        this.permissionChecker = permissionChecker;
        this.templates = templates;
    }

    @GET
    public List<UserAccount> find() {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        return this.getUserAccounts();
    }

    @GET
    @Path(value="names")
    public List<UserView> getUsernames() {
        return Lists.transform(this.getUserAccounts(), UserAccount.TO_USERVIEW);
    }

    private List<UserAccount> getUserAccounts() {
        ImmutableMap profiles = Maps.uniqueIndex(this.userProfiles.findAll(), BY_NAME);
        List<String> jcrNames = this.jcrUsers.getJcrUsernames();
        TreeSet<Object> allNames = new TreeSet<Object>(Collator.getInstance());
        allNames.addAll(jcrNames);
        allNames.addAll(profiles.keySet());
        ArrayList<UserAccount> accounts = new ArrayList<UserAccount>(allNames.size());
        for (String string : allNames) {
            accounts.add(new UserAccount(string, (UserProfile)((Object)profiles.get(string)), this.isInternalUser(jcrNames, string)));
        }
        return accounts;
    }

    private boolean isInternalUser(List<String> jcrNames, String name) {
        for (String jcrName : jcrNames) {
            if (!name.equalsIgnoreCase(jcrName)) continue;
            return true;
        }
        return false;
    }

    @POST
    public void create(UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        Preconditions.checkArgument((!Strings.isBlank((String)account.getUsername()) ? 1 : 0) != 0, (Object)"User name is required when creating a user.");
        Preconditions.checkArgument((!Strings.isBlank((String)account.getPassword()) ? 1 : 0) != 0, (Object)"Password is required when creating a user.");
        boolean created = this.createInJcr(account);
        if (!created) {
            throw new UserAlreadyExistsException("User %s already exists", account.getUsername());
        }
        this.createUserProfile(account);
        this.templates.startWelcomeRelease(account.getUsername());
    }

    @PUT
    @Path(value="{username}")
    public Response update(@PathParam(value="username") String username, UserAccount account) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        UserProfile existingProfile = this.userProfiles.findByUsername(username);
        UserProfile updatedProfile = new UserProfile(existingProfile.getId(), account.getEmail(), account.getFullName());
        this.userProfiles.save(updatedProfile);
        if (account.hasPassword() && this.jcrUsers.userExistsInJcr(username)) {
            Preconditions.checkArgument((!Objects.equals(username, "admin") ? 1 : 0) != 0, (Object)"Admin password can't be changed.");
            this.jcrUserService.modifyPassword(username, account.getPassword());
        }
        return Response.ok().build();
    }

    @DELETE
    @Path(value="{username}")
    public void delete(@PathParam(value="username") String username) {
        this.permissionChecker.check(PlatformPermissions.EDIT_SECURITY);
        this.jcrUserService.delete(username);
        this.userProfiles.delete(username);
    }

    private boolean createInJcr(UserAccount account) {
        try {
            this.jcrUserService.create(account.getUsername(), account.getPassword());
        }
        catch (RuntimeRepositoryException e) {
            Throwable cause = e.getCause();
            if (cause instanceof AuthorizableExistsException) {
                return false;
            }
            throw e;
        }
        return true;
    }

    private void createUserProfile(UserAccount account) {
        UserProfile profile = new UserProfile(this.userProfiles.buildId(account.getUsername()), account.getEmail(), account.getFullName());
        this.userProfiles.save(profile);
    }

    @HttpResponseCodeResult(statusCode=409)
    public static class UserAlreadyExistsException
    extends DeployitException {
        public UserAlreadyExistsException(String messageTemplate, Object ... params) {
            super(messageTemplate, params);
        }
    }
}

