/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.builder;

import com.google.common.base.Strings;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import java.util.Date;

public class ActivityLogBuilder {
    private ActivityLogEntry log;
    private String username;
    private Date eventTime;

    private ActivityLogBuilder(ActivityLogEntry log) {
        this.log = log;
    }

    public static ActivityLogBuilder newLog(ActivityLogEntry log) {
        return new ActivityLogBuilder(log);
    }

    public ActivityLogBuilder withUser(String user) {
        this.username = user;
        return this;
    }

    public ActivityLogBuilder withDate(Date date) {
        this.eventTime = date;
        return this;
    }

    public ActivityLogEntry build() {
        this.log.setEventTime(this.eventTime != null ? this.eventTime : new Date());
        if (!Strings.isNullOrEmpty((String)this.username)) {
            this.log.setUsername(this.username);
        }
        return this.log;
    }
}

