/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.concurrent;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.concurrent.ReleaseIdHolder;
import com.xebialabs.xlrelease.concurrent.Synchronized;
import com.xebialabs.xlrelease.repository.Ids;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.reflect.MethodSignature;

public class ReleaseSynchronizationAspect {
    @VisibleForTesting
    LoadingCache<String, ReentrantLock> lockCache = CacheBuilder.newBuilder().weakValues().build((CacheLoader)new CacheLoader<String, ReentrantLock>(){

        public ReentrantLock load(String key) throws Exception {
            return new ReentrantLock(true);
        }
    });
    private static final ThreadLocal<String> lastReleaseId = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object synchronizeOnRelease(ProceedingJoinPoint joinPoint) throws Throwable {
        String releaseId = ReleaseSynchronizationAspect.extractReleaseIdFromParameter(joinPoint);
        this.failIfAlreadyLockingOtherReleaseThan(releaseId);
        boolean isFirstAcquisition = this.registerLockAcquiredFor(releaseId);
        ReentrantLock lock = (ReentrantLock)this.lockCache.get((Object)releaseId);
        lock.lock();
        try {
            Object object = joinPoint.proceed();
            return object;
        }
        finally {
            lock.unlock();
            if (isFirstAcquisition) {
                this.registerLockFreed();
            }
        }
    }

    private void failIfAlreadyLockingOtherReleaseThan(String releaseId) {
        if (lastReleaseId.get() != null && !releaseId.equals(lastReleaseId.get())) {
            throw new IllegalStateException(String.format("Trying to lock two releases: %s and %s", lastReleaseId.get(), releaseId));
        }
    }

    private boolean registerLockAcquiredFor(String releaseId) {
        boolean isFirstAcquisition;
        boolean bl = isFirstAcquisition = lastReleaseId.get() == null;
        if (isFirstAcquisition) {
            lastReleaseId.set(releaseId);
        }
        return isFirstAcquisition;
    }

    private void registerLockFreed() {
        lastReleaseId.set(null);
    }

    private static String extractReleaseIdFromParameter(ProceedingJoinPoint joinPoint) {
        String configurationItemId;
        int parameterIndex = ReleaseSynchronizationAspect.getAnnotatedParameterIndex(joinPoint);
        Object releaseHolder = joinPoint.getArgs()[parameterIndex];
        if (releaseHolder instanceof String) {
            configurationItemId = Ids.releaseIdFrom((String)releaseHolder);
        } else {
            Preconditions.checkArgument((boolean)(releaseHolder instanceof ConfigurationItem), (String)"ReleaseIdHolder parameter must be a ConfigurationItem or a String, not %s", (Object[])new Object[]{releaseHolder.getClass().getName()});
            configurationItemId = ((ConfigurationItem)releaseHolder).getId();
        }
        return Ids.releaseIdFrom(configurationItemId);
    }

    private static int getAnnotatedParameterIndex(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            Annotation[] parameterAnnotation;
            for (Annotation annotation : parameterAnnotation = parameterAnnotations[i]) {
                if (!(annotation instanceof ReleaseIdHolder)) continue;
                return i;
            }
        }
        throw new IllegalArgumentException(String.format("%s methods must have a parameter annotated with %s", Synchronized.class.getSimpleName(), ReleaseIdHolder.class.getSimpleName()));
    }
}

