/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.configuration;

import com.google.common.base.Function;
import com.xebialabs.deployit.booter.remote.BooterConfig;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import java.net.URI;
import java.net.URISyntaxException;

@Metadata(description="A Deployit server definition.", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class DeployitServerDefinition
extends BaseConfigurationItem {
    @Property
    private String url;
    @Property
    private String username;
    @Property(password=true)
    private String password;
    public static final Function<DeployitServerDefinition, DeployitServerDefinition> ANONYMIZE = new Function<DeployitServerDefinition, DeployitServerDefinition>(){

        public DeployitServerDefinition apply(DeployitServerDefinition serverDefinition) {
            serverDefinition.setPassword(null);
            serverDefinition.setUsername(null);
            return serverDefinition;
        }
    };

    public DeployitServerDefinition() {
    }

    public DeployitServerDefinition(String id, String url, String username, String password) {
        this.id = id;
        this.url = url;
        this.username = username;
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public BooterConfig getBooterConfig() {
        URI uri = this.toUri();
        BooterConfig.Builder builder = BooterConfig.builder().withHost(uri.getHost()).withPort(uri.getPort()).withContext(uri.getPath()).withCredentials(this.username, this.password);
        if ("https".equals(uri.getScheme())) {
            builder.withProtocol(BooterConfig.Protocol.HTTPS);
        }
        return builder.build();
    }

    public URI toUri() {
        try {
            return new URI(this.url);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toString() {
        return this.toUri().toString();
    }
}

