/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.booter.local.utils.Strings;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.service.PostStartAction;
import java.util.List;
import java.util.Set;

public class Changes {
    private Set<ConfigurationItem> updatedItems = Sets.newLinkedHashSet();
    private List<ActivityLogEntry> activityLogEntries = Lists.newArrayList();
    private Multimap<String, String> commentsByTaskId = ArrayListMultimap.create();
    private Set<String> removedIds = Sets.newLinkedHashSet();
    private List<PostStartAction> postStartActions = Lists.newArrayList();

    public void addAll(Changes changes) {
        this.updatedItems.addAll(changes.getUpdatedItems());
        this.activityLogEntries.addAll(changes.getActivityLogEntries());
        this.commentsByTaskId.putAll(changes.getCommentsByTaskId());
        this.removedIds.addAll(changes.getRemovedIds());
        this.postStartActions.addAll(changes.getPostStartActions());
    }

    public void update(ConfigurationItem item, ActivityLogEntry activityLogEntry) {
        this.update(item);
        this.addLogEntry(activityLogEntry);
    }

    public void update(ConfigurationItem item) {
        this.updatedItems.add(item);
    }

    public void addLogEntry(ActivityLogEntry activityLogEntry) {
        this.activityLogEntries.add(activityLogEntry);
    }

    public void addLogEntries(List<ActivityLogEntry> logEntries) {
        this.activityLogEntries.addAll(logEntries);
    }

    public void addComment(String taskId, String comment) {
        if (!Strings.isBlank((String)comment)) {
            this.commentsByTaskId.put((Object)taskId, (Object)comment);
        }
    }

    public void addPostStartAction(PostStartAction postStartAction) {
        this.postStartActions.add(postStartAction);
    }

    public void remove(String id) {
        this.removedIds.add(id);
    }

    public boolean hasUpdatedItems() {
        return !this.updatedItems.isEmpty();
    }

    public Set<ConfigurationItem> getUpdatedItems() {
        return this.updatedItems;
    }

    public ConfigurationItem[] toUpdatedItemsArray() {
        return this.updatedItems.toArray(new ConfigurationItem[this.updatedItems.size()]);
    }

    public List<ActivityLogEntry> getActivityLogEntries() {
        return this.activityLogEntries;
    }

    public Multimap<String, String> getCommentsByTaskId() {
        return this.commentsByTaskId;
    }

    public Set<String> getRemovedIds() {
        return this.removedIds;
    }

    public String[] toRemovedIdsArray() {
        return this.removedIds.toArray(new String[this.removedIds.size()]);
    }

    public List<PostStartAction> getPostStartActions() {
        return this.postStartActions;
    }
}

