/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ImmutableSet;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.xlrelease.domain.CustomScriptTask;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.NotificationTask;
import com.xebialabs.xlrelease.domain.ParallelGroup;
import com.xebialabs.xlrelease.domain.ScriptTask;
import com.xebialabs.xlrelease.domain.Task;
import java.util.HashSet;
import java.util.Set;

public enum DefaultTaskTypes {
    MANUAL(Task.class),
    DEPLOYIT(DeployitTask.class),
    GATE(GateTask.class),
    NOTIFICATION(NotificationTask.class),
    SCRIPT(ScriptTask.class),
    PARALLEL_GROUP(ParallelGroup.class),
    CUSTOM_SCRIPT_TASK(CustomScriptTask.class);

    private final Type type;
    private static final Set<Type> TYPES;

    public String getTypeName() {
        return this.type.toString();
    }

    public Type getType() {
        return this.type;
    }

    private DefaultTaskTypes(Class<? extends Task> taskClass) {
        this.type = Type.valueOf(taskClass);
    }

    public static boolean isDefaultTaskType(Type type) {
        return TYPES.contains(type);
    }

    static {
        HashSet<Type> tmp = new HashSet<Type>();
        for (DefaultTaskTypes value : DefaultTaskTypes.values()) {
            boolean added = tmp.add(value.type);
            if (!added) {
                throw new AssertionError((Object)"duplicate types");
            }
        }
        TYPES = ImmutableSet.copyOf(tmp);
    }
}

