/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.Dependency;
import com.xebialabs.xlrelease.domain.FailureReasons;
import com.xebialabs.xlrelease.domain.GateCondition;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GateTask
extends Task {
    @Property(asContainment=true, required=false)
    private List<GateCondition> conditions = Lists.newArrayList();
    @Property(asContainment=true, required=false)
    private List<Dependency> dependencies = Lists.newArrayList();

    public List<GateCondition> getConditions() {
        return this.conditions;
    }

    public boolean hasConditions() {
        return !this.conditions.isEmpty();
    }

    public void setConditions(List<GateCondition> conditions) {
        this.conditions = conditions;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<Dependency> dependencies) {
        this.dependencies = dependencies;
    }

    public boolean hasDependencies() {
        return !this.dependencies.isEmpty();
    }

    public void addDependency(Dependency dependency) {
        this.dependencies.add(dependency);
    }

    @Override
    protected Changes execute(String targetId, ReleaseActivity activity) {
        Changes changes = super.execute(targetId, activity);
        if (this.getStatus() != TaskStatus.IN_PROGRESS) {
            return changes;
        }
        if (this.isCompletable()) {
            changes.addAll(this.markAsDone(this.getId(), TaskStatus.COMPLETED));
        } else if (this.hasOneAbortedDependency()) {
            String titles = this.getAbortedDependencyTitles();
            changes.addAll(this.fail(this.getId(), FailureReasons.GATE_TASK_DEPENDS_ON_AN_ABORTED_RELEASE.format(titles)));
        }
        return changes;
    }

    @Override
    public Changes markAsDone(String targetId, TaskStatus targetStatus) {
        if (targetStatus == TaskStatus.COMPLETED_IN_ADVANCE) {
            Preconditions.checkState((boolean)this.isOpenInAdvance(), (String)"All conditions and dependencies on gate '%s' must be fulfilled before completing it.", (Object[])new Object[]{this.getTitle()});
        } else if (targetStatus == TaskStatus.COMPLETED && this.getStatus() == TaskStatus.COMPLETED_IN_ADVANCE) {
            Preconditions.checkState((boolean)this.isOpenWithStatus(TaskStatus.COMPLETED_IN_ADVANCE), (String)"All conditions and dependencies on gate '%s' must be fulfilled before completing it.", (Object[])new Object[]{this.getTitle()});
        } else {
            Preconditions.checkArgument((targetStatus != TaskStatus.COMPLETED || this.isOpen() ? 1 : 0) != 0, (String)"All conditions and dependencies on gate '%s' must be fulfilled before completing it.", (Object[])new Object[]{this.getTitle()});
        }
        return super.markAsDone(targetId, targetStatus);
    }

    public boolean isOpen() {
        return this.isOpenWithStatus(TaskStatus.IN_PROGRESS);
    }

    private boolean isOpenInAdvance() {
        return this.isOpenWithStatus(TaskStatus.PLANNED);
    }

    private boolean isOpenWithStatus(TaskStatus requiredStatus) {
        if (this.getStatus() != requiredStatus) {
            return false;
        }
        for (GateCondition condition : this.conditions) {
            if (condition.isChecked()) continue;
            return false;
        }
        for (Dependency dependency : this.dependencies) {
            if (((PlanItem)((Object)dependency.getTarget())).isDone()) continue;
            return false;
        }
        return true;
    }

    public boolean isCompletable() {
        return (this.hasConditions() || this.hasDependencies()) && this.isOpen();
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        super.accept(visitor);
        visitor.visit(this);
    }

    public List<PlanItem> getNotDoneTargets() {
        ArrayList targets = Lists.newArrayList();
        for (Dependency dependency : this.getDependencies()) {
            if (((PlanItem)((Object)dependency.getTarget())).isDone()) continue;
            targets.add(dependency.getTarget());
        }
        return targets;
    }

    @Override
    protected Set<String> freezeVariablesInCustomFields(Map<String, String> variables, Changes changes, boolean freezeEvenIfUnresolved) {
        HashSet unresolvedVariables = Sets.newHashSet();
        for (GateCondition condition : this.conditions) {
            String oldTitle = condition.getTitle();
            String newTitle = this.replaceAll(oldTitle, variables, unresolvedVariables, freezeEvenIfUnresolved);
            if (newTitle.equals(oldTitle)) continue;
            condition.setTitle(newTitle);
            changes.update((ConfigurationItem)condition);
        }
        return unresolvedVariables;
    }

    private boolean hasOneAbortedDependency() {
        for (Dependency dependency : this.dependencies) {
            if (!((PlanItem)((Object)dependency.getTarget())).isAborted()) continue;
            return true;
        }
        return false;
    }

    private String getAbortedDependencyTitles() {
        ArrayList titles = Lists.newArrayList();
        for (Dependency dependency : this.dependencies) {
            if (!((PlanItem)((Object)dependency.getTarget())).isAborted()) continue;
            titles.add(Strings.nullToEmpty((String)((PlanItem)((Object)dependency.getTarget())).getTitle()));
        }
        return Joiner.on((String)"', '").join((Iterable)titles);
    }
}

