/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.repository.core.Securable;
import com.xebialabs.deployit.security.Role;
import com.xebialabs.deployit.security.permission.Permission;
import com.xebialabs.xlrelease.calendar.ReleaseCalendar;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import com.xebialabs.xlrelease.domain.Attachment;
import com.xebialabs.xlrelease.domain.Changes;
import com.xebialabs.xlrelease.domain.DeployitTask;
import com.xebialabs.xlrelease.domain.FlagStatus;
import com.xebialabs.xlrelease.domain.GateTask;
import com.xebialabs.xlrelease.domain.Phase;
import com.xebialabs.xlrelease.domain.PhaseStatus;
import com.xebialabs.xlrelease.domain.PlanItem;
import com.xebialabs.xlrelease.domain.ReleaseActivity;
import com.xebialabs.xlrelease.domain.ReleaseStatus;
import com.xebialabs.xlrelease.domain.ReleaseVisitor;
import com.xebialabs.xlrelease.domain.Task;
import com.xebialabs.xlrelease.domain.TaskStatus;
import com.xebialabs.xlrelease.domain.Team;
import com.xebialabs.xlrelease.domain.Variable;
import com.xebialabs.xlrelease.domain.VariableCollectingVisitor;
import com.xebialabs.xlrelease.views.ReleaseSecurity;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;

@Metadata(description="A Release.", root=Metadata.ConfigurationItemRoot.APPLICATIONS)
public class Release
extends PlanItem
implements Securable {
    @Property(asContainment=true, required=false)
    protected List<Phase> phases = Lists.newArrayList();
    @Property(asContainment=true, required=false)
    protected List<Team> teams = Lists.newArrayList();
    @Property(asContainment=true, required=false)
    private Map<String, String> variableValues = Maps.newHashMap();
    @Property
    private ReleaseStatus status;
    @Property(asContainment=true, required=false)
    private List<ActivityLogEntry> activityLogEntries = Lists.newArrayList();
    @Property(required=false)
    private List<String> tags;
    @Property(asContainment=true, required=false)
    private List<Attachment> attachments = Lists.newArrayList();
    @Property(required=false)
    private String calendarLinkToken;
    @Property(required=false)
    private boolean calendarPublished;
    @Property(required=false)
    private boolean tutorial;
    private ReleaseSecurity releaseSecurity;
    private static final Predicate<Phase> IS_PLANNED = new Predicate<Phase>(){

        public boolean apply(Phase phase) {
            return phase.isPlanned();
        }
    };

    public List<Phase> getPhases() {
        return this.phases;
    }

    public void setPhases(List<Phase> phases) {
        this.phases = phases;
    }

    public Map<String, String> getVariableValues() {
        return this.variableValues;
    }

    public void setVariableValues(Map<String, String> variableValues) {
        this.variableValues = variableValues;
    }

    public void addVariableValues(Map<String, String> variableValues) {
        this.variableValues.putAll(variableValues);
    }

    public ReleaseStatus getStatus() {
        return this.status;
    }

    public void setStatus(ReleaseStatus value) {
        this.status = value;
    }

    public List<Team> getTeams() {
        return this.teams;
    }

    public boolean hasTeam(String teamName) {
        for (Team team : this.teams) {
            if (!team.getTeamName().equals(teamName)) continue;
            return true;
        }
        return false;
    }

    public void setTeams(List<Team> teams) {
        this.teams = teams;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public void deleteAttachment(String attachmentId) {
        Iterator<Attachment> iterator = this.attachments.iterator();
        while (iterator.hasNext()) {
            Attachment attachement = iterator.next();
            if (!attachmentId.equals(attachement.getId())) continue;
            iterator.remove();
            return;
        }
    }

    public Set<Task> getTasksUsingAttachment(String attachmentId) {
        HashSet tasks = Sets.newHashSet();
        for (Task task : this.getAllTasks()) {
            for (Attachment attachment : task.getAttachments()) {
                if (!attachment.getId().equals(attachmentId)) continue;
                tasks.add(task);
            }
        }
        return tasks;
    }

    public List<Attachment> getReleaseAttachments() {
        HashSet attachments = Sets.newHashSet(this.attachments);
        List<Task> allTasks = this.getAllTasks();
        for (Task task : allTasks) {
            attachments.removeAll(task.getAttachments());
        }
        return Lists.newArrayList((Iterable)attachments);
    }

    public String getCalendarLinkToken() {
        return this.calendarLinkToken;
    }

    public void setCalendarLinkToken(String calendarLinkToken) {
        this.calendarLinkToken = calendarLinkToken;
    }

    public boolean isCalendarPublished() {
        return this.calendarPublished;
    }

    public void setCalendarPublished(boolean calendarPublished) {
        this.calendarPublished = calendarPublished;
    }

    public List<ActivityLogEntry> getActivityLogEntries() {
        return this.activityLogEntries;
    }

    public void setActivityLogEntries(List<ActivityLogEntry> activityLogEntries) {
        this.activityLogEntries = activityLogEntries;
    }

    public ReleaseSecurity getReleaseSecurity() {
        return this.releaseSecurity;
    }

    public void setReleaseSecurity(ReleaseSecurity releaseSecurity) {
        this.releaseSecurity = releaseSecurity;
    }

    public Phase getCurrentPhase() {
        return (Phase)((Object)Iterables.find(this.getPhases(), (Predicate)new Predicate<Phase>(){

            public boolean apply(Phase phase) {
                return phase.getStatus() == PhaseStatus.IN_PROGRESS || phase.isFailing() || phase.isFailed();
            }
        }, null));
    }

    public Task getCurrentTask() {
        Phase currentPhase = this.getCurrentPhase();
        if (currentPhase != null) {
            return currentPhase.getCurrentTask();
        }
        return null;
    }

    public boolean hasCurrentPhase() {
        return null != this.getCurrentPhase();
    }

    @VisibleForTesting
    void complete() {
        this.setStatus(ReleaseStatus.COMPLETED);
        this.setEndDate(new Date());
        this.setFlagStatus(FlagStatus.OK);
        this.setFlagComment("");
        this.freezeVariables();
    }

    public Changes start() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_STARTED.create(new Object[0]));
        if (this.hasPhase()) {
            Phase firstPhase = this.getPhases().get(0);
            changes.addAll(this.startActivablePhase(firstPhase));
        } else {
            this.complete();
            changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_COMPLETED.create(new Object[0]));
        }
        return changes;
    }

    public Changes restart() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.IN_PROGRESS);
        this.setStartDate(new Date());
        changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_RESTARTED.create(new Object[0]));
        Phase firstPlannedPhase = (Phase)((Object)Iterables.find(this.getPhases(), IS_PLANNED));
        changes.addAll(this.startActivablePhase(firstPlannedPhase));
        return changes;
    }

    private boolean hasPhase() {
        return !this.getPhases().isEmpty();
    }

    private Changes startActivablePhase(Phase phase) {
        Changes changes = new Changes();
        changes.addAll(phase.start());
        changes.addAll(this.checkPhaseStatus(phase));
        return changes;
    }

    private Changes checkPhaseStatus(Phase phase) {
        Changes changes = new Changes();
        if (phase.isDone()) {
            changes.addAll(this.startNextPhase(phase));
        } else if (phase.isFailed()) {
            changes.addAll(this.fail());
        } else if (phase.isFailing()) {
            changes.addAll(this.failing());
        }
        return changes;
    }

    private Changes startNextPhase(Phase phase) {
        Changes changes = new Changes();
        if (this.hasNextPhase(phase)) {
            Phase nextPhase = this.getNextPhase(phase);
            changes.addAll(this.startActivablePhase(nextPhase));
        } else {
            this.complete();
            changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_COMPLETED.create(new Object[0]));
        }
        return changes;
    }

    public Changes markTaskAsDone(String taskId, TaskStatus status) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(this.recoverReleaseIfNeeded());
            changes.addAll(currentPhase.markTaskAsDone(taskId, status));
            changes.addAll(this.checkPhaseStatus(currentPhase));
        }
        return changes;
    }

    private Changes recoverReleaseIfNeeded() {
        Changes changes = new Changes();
        if (this.getStatus() == ReleaseStatus.FAILED || this.getStatus() == ReleaseStatus.FAILING) {
            changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_RESTARTED.create(new Object[0]));
            this.setStatus(ReleaseStatus.IN_PROGRESS);
        }
        return changes;
    }

    public Changes startPendingTask(String taskId) {
        Changes changes = new Changes();
        if (this.hasCurrentPhase()) {
            Phase currentPhase = this.getCurrentPhase();
            changes.addAll(currentPhase.startPendingTask(taskId));
            changes.addAll(this.checkPhaseStatus(currentPhase));
        }
        return changes;
    }

    public Changes failTask(String taskId, String failReason) {
        Changes changes = new Changes();
        for (Phase phase : this.phases) {
            Changes updatedPhaseItems = phase.failTask(taskId, failReason);
            if (!updatedPhaseItems.hasUpdatedItems()) continue;
            changes.addAll(updatedPhaseItems);
            if (phase.isFailed()) {
                changes.addAll(this.fail());
                continue;
            }
            if (!phase.isFailing()) continue;
            changes.addAll(this.failing());
        }
        return changes;
    }

    private Changes fail() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.FAILED);
        changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_FAILED.create(new Object[0]));
        return changes;
    }

    private Changes failing() {
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.FAILING);
        changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_FAILING.create(new Object[0]));
        return changes;
    }

    public Changes abort() {
        Preconditions.checkState((this.getStatus() != ReleaseStatus.TEMPLATE ? 1 : 0) != 0, (Object)"Can't abort a template release");
        Changes changes = new Changes();
        this.setStatus(ReleaseStatus.ABORTED);
        this.setEndDate(new Date());
        changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_ABORTED.create(new Object[0]));
        for (Phase phase : this.phases) {
            if (phase.isDone()) continue;
            changes.addAll(phase.abort());
        }
        return changes;
    }

    public Changes retryTask(String taskId) {
        Changes changes = new Changes();
        for (Phase phase : this.phases) {
            Changes updatedPhaseItems = phase.retryTask(taskId);
            if (!updatedPhaseItems.hasUpdatedItems()) continue;
            this.setStatus(ReleaseStatus.IN_PROGRESS);
            changes.addAll(updatedPhaseItems);
            changes.update((ConfigurationItem)this, ReleaseActivity.RELEASE_RESTARTED.create(new Object[0]));
        }
        return changes;
    }

    public Phase getNextPhase(Phase currentPhase) {
        int currentPhasePosition = this.phases.indexOf((Object)currentPhase) + 1;
        ListIterator<Phase> iterator = this.phases.listIterator(currentPhasePosition);
        return iterator.hasNext() ? iterator.next() : null;
    }

    public boolean hasNextPhase(Phase phase) {
        return this.getNextPhase(phase) != null;
    }

    public void addPhase(Phase phase) {
        this.phases.add(phase);
    }

    @Override
    public List<Task> getAllTasks() {
        ArrayList tasks = Lists.newArrayList();
        for (Phase phase : this.phases) {
            tasks.addAll(phase.getAllTasks());
        }
        return tasks;
    }

    public Task getTask(String taskId) {
        for (Task task : this.getAllTasks()) {
            if (!taskId.equals(task.getId())) continue;
            return task;
        }
        return null;
    }

    public Team getAdminTeam() {
        for (Team team : this.teams) {
            if (!team.getTeamName().equals("Release Admin")) continue;
            return team;
        }
        return null;
    }

    public Set<String> getTeamsOf(String username, List<Role> userRoles) {
        HashSet userTeams = Sets.newHashSet();
        for (Team team : this.teams) {
            if (!team.hasMember(username) && !team.hasAnyRole(userRoles)) continue;
            userTeams.add(team.getTeamName());
        }
        return userTeams;
    }

    public boolean isMemberOfTeam(String teamName, String username) {
        for (Team team : this.teams) {
            if (!team.getTeamName().equals(teamName)) continue;
            return team.hasMember(username);
        }
        return false;
    }

    public boolean isRoleOfTeam(String teamName, String roleName) {
        for (Team team : this.teams) {
            if (!team.getTeamName().equals(teamName)) continue;
            return team.hasRole(roleName);
        }
        return false;
    }

    public Phase movePhase(Integer originIndex, Integer targetIndex) {
        Phase phaseToMove = this.phases.get(originIndex);
        Phase targetPhase = this.phases.get(targetIndex);
        Preconditions.checkArgument((phaseToMove.isPlanned() && targetPhase.isPlanned() ? 1 : 0) != 0, (Object)"Only planned phases can be moved.");
        this.phases.remove((Object)phaseToMove);
        this.phases.add(targetIndex, phaseToMove);
        return phaseToMove;
    }

    public Phase getPhase(Integer index) {
        return this.phases.get(index);
    }

    public Phase getPhase(final String phaseId) {
        return (Phase)((Object)Iterables.find(this.getPhases(), (Predicate)new Predicate<Phase>(){

            public boolean apply(Phase phase) {
                return Objects.equal((Object)phase.getId(), (Object)phaseId);
            }
        }, null));
    }

    public boolean hasPhase(String phaseId) {
        return this.getPhase(phaseId) != null;
    }

    public void addTeam(Team team) {
        this.teams.add(team);
    }

    public void deleteTeam(String teamId) {
        Iterator<Team> i = this.teams.iterator();
        while (i.hasNext()) {
            Team team = i.next();
            if (!team.getId().equals(teamId)) continue;
            Preconditions.checkArgument((!team.isSystemTeam() ? 1 : 0) != 0, (String)"The predefined '%s' team can not be deleted.", (Object[])new Object[]{team.getTeamName()});
            i.remove();
        }
    }

    public void addBelow(String phaseId, Phase addedPhase) {
        this.addBelow(phaseId, Lists.newArrayList((Object[])new Phase[]{addedPhase}));
    }

    public void addBelow(String phaseId, List<Phase> phasesToAdd) {
        for (int i = 0; i < this.getPhases().size(); ++i) {
            Phase phase = this.getPhase(i);
            if (!phase.getId().equals(phaseId)) continue;
            this.phases.addAll(i + 1, phasesToAdd);
        }
    }

    public void updateDatesForRelease(Date scheduledStartDate, Date dueDate, Long plannedDuration) {
        Preconditions.checkArgument((dueDate != null ? 1 : 0) != 0, (Object)"Due date must be set");
        this.updateDatesForTemplate(scheduledStartDate, dueDate, plannedDuration);
    }

    public void updateDatesForTemplate(Date scheduledStartDate, Date dueDate, Long plannedDuration) {
        Preconditions.checkArgument((scheduledStartDate != null ? 1 : 0) != 0, (Object)"Scheduled start date must be set");
        super.updateDates(scheduledStartDate, dueDate, plannedDuration);
    }

    public Set<Variable> collectVariableReferences() {
        VariableCollectingVisitor visitor = new VariableCollectingVisitor();
        this.accept(visitor);
        return visitor.result();
    }

    public List<GateTask> getAllGates() {
        return this.getAllTasksOfType(GateTask.class);
    }

    public List<DeployitTask> getAllDeployitTasks() {
        return this.getAllTasksOfType(DeployitTask.class);
    }

    private <T> List<T> getAllTasksOfType(Class<T> clazz) {
        List<Task> allTasks = this.getAllTasks();
        return Lists.newArrayList((Iterable)Iterables.filter(allTasks, clazz));
    }

    @Override
    public void accept(ReleaseVisitor visitor) {
        visitor.visit(this);
        for (Phase phase : this.phases) {
            phase.accept(visitor);
        }
    }

    public Date findFirstSetDate() {
        for (Phase phase : this.getPhases()) {
            if (phase.hasScheduledStartDate()) {
                return phase.getScheduledStartDate();
            }
            for (Task task : phase.getAllTasks()) {
                if (!task.hasScheduledStartDate()) continue;
                return task.getScheduledStartDate();
            }
        }
        return DateTime.now().withHourOfDay(9).withMinuteOfHour(0).withSecondOfMinute(0).withMillisOfSecond(0).toDate();
    }

    @Override
    public boolean hasBeenStarted() {
        return this.status != null && this.status.hasBeenStarted();
    }

    @Override
    public boolean isDone() {
        return this.status == ReleaseStatus.COMPLETED;
    }

    @Override
    public boolean isActive() {
        return this.status != null && this.status.isActive();
    }

    @Override
    public boolean isDefunct() {
        return this.isAborted() || this.isDone();
    }

    @Override
    public boolean isUpdatable() {
        return !this.isDefunct();
    }

    @Override
    public boolean isAborted() {
        return this.status == ReleaseStatus.ABORTED;
    }

    public boolean isFailing() {
        return this.status == ReleaseStatus.FAILING;
    }

    public boolean isFailed() {
        return this.status == ReleaseStatus.FAILED;
    }

    public boolean isPaused() {
        return this.status == ReleaseStatus.PAUSED;
    }

    public boolean isTemplate() {
        return this.status == ReleaseStatus.TEMPLATE;
    }

    public boolean isInProgress() {
        return this.status == ReleaseStatus.IN_PROGRESS;
    }

    public boolean isTutorial() {
        return this.tutorial;
    }

    public void setTutorial(boolean tutorial) {
        this.tutorial = tutorial;
    }

    @Override
    public Release getRelease() {
        return this;
    }

    @Override
    public String getDisplayPath() {
        return this.getTitle();
    }

    @VisibleForTesting
    boolean hasPermission(String user, List<Role> roles, String permission) {
        for (Team team : this.teams) {
            if (team.hasMember(user) && team.hasPermission(permission)) {
                return true;
            }
            for (Role role : roles) {
                if (!team.hasRole(role.getName()) || !team.hasPermission(permission)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPermission(String user, List<Role> roles, Permission permission) {
        return this.hasPermission(user, roles, permission.getPermissionName());
    }

    public Set<String> getPermissions(String user, List<Role> userRoles) {
        HashSet permissions = Sets.newHashSet();
        for (Team team : this.teams) {
            if (!team.hasMember(user) && !team.hasAnyRole(userRoles)) continue;
            permissions.addAll(team.getPermissions());
        }
        return permissions;
    }

    public Team getTeamWithId(String id) {
        for (Team team : this.teams) {
            if (!team.getId().equals(id)) continue;
            return team;
        }
        throw new IllegalStateException("Release " + this.getId() + " doesn't contain team with id " + id);
    }

    public String toICS() {
        return new ReleaseCalendar(this).toString();
    }

    @Override
    public boolean isFlagged() {
        if (super.isFlagged()) {
            return true;
        }
        for (Task task : this.getAllTasks()) {
            if (!task.isFlagged()) continue;
            return true;
        }
        return false;
    }

    public List<PlanItem> getOutgoingDependencies() {
        ArrayList targets = Lists.newArrayList();
        for (GateTask gate : this.getAllGates()) {
            targets.addAll(gate.getNotDoneTargets());
        }
        return targets;
    }

    @Override
    public List<PlanItem> getChildren() {
        ArrayList planItems = Lists.newArrayList();
        planItems.addAll(this.phases);
        planItems.addAll(this.getAllTasks());
        return planItems;
    }

    public List<PlanItem> getAllPlanItems() {
        ArrayList planItems = Lists.newArrayList();
        planItems.add(this);
        planItems.addAll(this.getChildren());
        return planItems;
    }

    private void freezeVariables() {
        if (this.variableValues == null || this.variableValues.isEmpty()) {
            return;
        }
        this.setDescription(this.replaceAll(this.getDescription(), this.variableValues, Sets.newHashSet(), false));
    }

    public String toString() {
        return Objects.toStringHelper((Object)((Object)this)).add("id", (Object)this.getId()).add("title", (Object)this.getTitle()).add("status", (Object)this.getStatus()).toString();
    }
}

