/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.xebialabs.xlrelease.domain.ActivityCategory;
import com.xebialabs.xlrelease.domain.ActivityLogEntry;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ReleaseActivity {
    TEMPLATE_CREATED("Created template", ActivityCategory.LIFECYCLE),
    TEMPLATE_DUPLICATED("Duplicated template to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_TITLE_UPDATED("Changed title from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_DESCRIPTION_UPDATED("Changed description from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_DUE_DATE_UPDATED("Changed due date from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_OWNER_UPDATED("Changed owner from %s to %s", ActivityCategory.REASSIGN, ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLES_UPDATED("Updated variables:\n%s", ActivityCategory.RELEASE_EDIT),
    RELEASE_VARIABLE_UPDATED("Updated release variable '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    RELEASE_TAGS_UPDATED("Updated tags to:\n%s", ActivityCategory.RELEASE_EDIT),
    RELEASE_FLAG_STATUS_UPDATED("Changed flag status from '%s' to '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.IMPORTANT),
    RELEASE_FLAG_COMMENT_UPDATED("Changed flag comment from '%s' to '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.IMPORTANT, ActivityCategory.COMMENTS),
    COMMENT_ADDED("Added a comment '%s' on task '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.COMMENTS),
    COMMENT_UPDATED("Updated comment '%s' to '%s' on task '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.COMMENTS),
    PHASE_CREATED("Created Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_RENAMED("Renamed Phase '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DESCRIPTION_UPDATED("Changed description of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DURATION_UPDATED("Changed duration of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DUE_DATE_UPDATED("Changed due date of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_COLOR_CHANGED("Changed color of Phase '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_MOVED("Moved Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DELETED("Deleted Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_DUPLICATED("Duplicated Phase '%s'", ActivityCategory.RELEASE_EDIT),
    PHASE_STARTED("Started Phase '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    PHASE_FAILED("Failed Phase '%s'", ActivityCategory.LIFECYCLE),
    PHASE_FAILING("Phase '%s' started failing", ActivityCategory.LIFECYCLE),
    PHASE_RESTARTED("Restarted Phase '%s'", ActivityCategory.LIFECYCLE),
    PHASE_COMPLETED("Completed Phase '%s'", ActivityCategory.LIFECYCLE),
    PHASE_CLOSED("Closed Phase '%s' and skipped all its tasks", ActivityCategory.LIFECYCLE),
    TASK_CREATED("Created Task '%s' of type '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.TASK_EDIT),
    TASK_MOVED_BETWEEN_CONTAINERS("Moved Task '%s' from '%s' to '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_MOVED_WITHIN_CONTAINER("Moved Task '%s' within '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_DELETED("Deleted Task '%s'", ActivityCategory.RELEASE_EDIT, ActivityCategory.IMPORTANT),
    TASK_TITLE_UPDATED("Changed title of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DESCRIPTION_UPDATED("Changed description of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DURATION_UPDATED("Changed duration of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_OWNER_UPDATED("Changed owner of Task '%s' from %s to %s", ActivityCategory.TASK_EDIT, ActivityCategory.REASSIGN),
    TASK_TASK_TEAM_UPDATED("Changed team of Task '%s' from %s to %s", ActivityCategory.TASK_EDIT, ActivityCategory.REASSIGN),
    TASK_DUE_DATE_UPDATED("Changed due date of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_SCHEDULED_START_DATE_UPDATED("Changed scheduled start date of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_WAIT_FOR_SCHEDULED_START_DATE_UPDATED("Changed wait for scheduled start date of Task '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DEPLOYIT_SERVER_UPDATED("Changed Deployit server of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_FLAG_STATUS_UPDATED("Flagged Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.IMPORTANT),
    TASK_FLAG_COMMENT_UPDATED("Changed flag status of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.IMPORTANT, ActivityCategory.COMMENTS),
    TASK_DEPLOYIT_PACKAGE_UPDATED("Changed Deployment Package of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DEPLOYIT_ENVIRONMENT_UPDATED("Changed Deployment Environment of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DEPLOYIT_USERNAME_UPDATED("Changed Deployment Username of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_DEPLOYIT_PASSWORD_UPDATED("Changed Deployment Password of Task '%s'", ActivityCategory.TASK_EDIT),
    TASK_DUPLICATED("Duplicated Task '%s'", ActivityCategory.RELEASE_EDIT),
    TASK_NOTIFICATION_ADDRESSES_UPDATED("Changed Notification addresses of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_SUBJECT_UPDATED("Changed Notification subject of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_NOTIFICATION_BODY_UPDATED("Changed Notification body of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_SCRIPT_UPDATED("Changed Script of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_INPUT_PROPERTY_UPDATED("Changed input property '%s' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TASK_INPUT_PROPERTY_PASSWORD_UPDATED("Changed input property '%s' of Task '%s'", ActivityCategory.TASK_EDIT),
    TASK_OUTPUT_PROPERTIES_UPDATED("Changed output property '%s' of Task '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    TEAM_CREATED("Created Team '%s'", ActivityCategory.SECURITY, ActivityCategory.RELEASE_EDIT),
    TEAM_UPDATED("Updated Team '%s' with members '%s' and roles '%s'", ActivityCategory.REASSIGN, ActivityCategory.SECURITY),
    TEAM_DELETED("Removed Team '%s'", ActivityCategory.SECURITY, ActivityCategory.RELEASE_EDIT),
    GATE_CONDITION_CREATED("Created Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT),
    GATE_CONDITION_TITLE_UPDATED("Updated title on Condition '%s' of gate '%s' from '%s' to '%s'", ActivityCategory.TASK_EDIT),
    GATE_CONDITION_FULLFILLED("Fullfilled Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.LIFECYCLE),
    GATE_CONDITION_UNFULLFILLED("Unfullfilled Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT, ActivityCategory.LIFECYCLE),
    GATE_CONDITION_UPDATED("Updated Condition '%s' on gate '%s'", ActivityCategory.TASK_EDIT),
    GATE_CONDITION_DELETED("Deleted Condition '%s' from gate '%s'", ActivityCategory.TASK_EDIT),
    LINK_ADDED("Created Link on Group '%s' from Task '%s' to Task '%s'", ActivityCategory.TASK_EDIT),
    LINK_REMOVED("Removed Link on Group '%s' from Task '%s' to Task '%s'", ActivityCategory.TASK_EDIT),
    DEPENDENCY_CREATED("Added Dependency in gate '%s' on '%s'", ActivityCategory.TASK_EDIT),
    DEPENDENCY_UPDATED("Changed Dependency in gate '%s' on '%s' to '%s'", ActivityCategory.TASK_EDIT),
    DEPENDENCY_DELETED("Deleted Dependency in gate '%s' on '%s'", ActivityCategory.TASK_EDIT),
    RELEASE_CREATED_FROM_TEMPLATE("Created Release '%s' from template '%s'", ActivityCategory.LIFECYCLE),
    RELEASE_CREATED("Created Empty Release '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.RELEASE_EDIT),
    RELEASE_STARTED("Started Release", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    RELEASE_FAILED("Failed Release", ActivityCategory.LIFECYCLE),
    RELEASE_FAILING("Release started failing", ActivityCategory.LIFECYCLE),
    RELEASE_RESTARTED("Restarted Release", ActivityCategory.LIFECYCLE),
    RELEASE_COMPLETED("Completed Release", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    RELEASE_ABORTED("Aborted Release", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_STARTED("Started Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_DELAYED("Activated Task '%s' with a scheduled start date of '%s'", ActivityCategory.LIFECYCLE),
    TASK_COMPLETED("Completed Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_COMPLETED_IN_ADVANCE("Completed in advance Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_SKIPPED("Skipped Task '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_SKIPPED_IN_ADVANCE("Skipped in advance Task '%s'", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_FAILED("Failed Task '%s': %s", ActivityCategory.LIFECYCLE, ActivityCategory.IMPORTANT),
    TASK_RESTARTED("Restarted Task '%s'", ActivityCategory.LIFECYCLE),
    TASK_FAILING("Task '%s' started failing", ActivityCategory.LIFECYCLE),
    TASK_REOPENED("Task '%s' reopened", ActivityCategory.LIFECYCLE),
    TEMPLATE_IMPORTED("Imported template", ActivityCategory.RELEASE_EDIT),
    PERMISSIONS_UPDATED("Updated permissions to:\n%s", ActivityCategory.SECURITY),
    ATTACHMENT_ADDED("Added attachment: '%s' (%s)", ActivityCategory.RELEASE_EDIT),
    ATTACHMENT_ADDED_ON_TASK("Added attachment: '%s' (%s) on task: '%s'", ActivityCategory.RELEASE_EDIT),
    ATTACHMENT_DELETED("Deleted attachment: '%s'", ActivityCategory.RELEASE_EDIT),
    ATTACHMENT_DELETED_FROM_TASK("Deleted attachment: '%s' from task : '%s'", ActivityCategory.RELEASE_EDIT),
    OTHER("", ActivityCategory.OTHER);

    private String message;
    private Set<ActivityCategory> categories = Sets.newLinkedHashSet();
    private static final Map<String, ReleaseActivity> BY_NAME;
    private static final Logger logger;

    private ReleaseActivity(String message, ActivityCategory ... categories) {
        this.message = message;
        LinkedHashSet myCategories = Sets.newLinkedHashSet();
        if (categories != null) {
            Collections.addAll(myCategories, categories);
        }
        this.categories = Collections.unmodifiableSet(myCategories);
    }

    public ActivityLogEntry create(Object ... parameters) {
        ActivityLogEntry logEntry = new ActivityLogEntry(this.name(), this.format(ReleaseActivity.formatNulls(parameters)));
        logger.info(logEntry.toString());
        return logEntry;
    }

    public String format(Object ... parameters) {
        return String.format(this.message, parameters);
    }

    private static Object[] formatNulls(Object[] parameters) {
        for (int i = 0; i < parameters.length; ++i) {
            if (null != parameters[i]) continue;
            parameters[i] = "";
        }
        return parameters;
    }

    public Set<ActivityCategory> getCategories() {
        return this.categories;
    }

    public String toString() {
        return this.message;
    }

    public static ReleaseActivity safeValueOf(String name) {
        ReleaseActivity activity = BY_NAME.get(name);
        return activity == null ? OTHER : activity;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ReleaseActivity value : ReleaseActivity.values()) {
            builder.put((Object)value.name(), (Object)value);
        }
        BY_NAME = builder.build();
        logger = LoggerFactory.getLogger(ReleaseActivity.class);
    }
}

