/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.xlrelease.domain;

public enum TaskStatus {
    PLANNED("planned"),
    PENDING("pending"),
    IN_PROGRESS("in_progress"),
    COMPLETED("completed"),
    COMPLETED_IN_ADVANCE("completed_in_advance"),
    SKIPPED("skipped"),
    SKIPPED_IN_ADVANCE("skipped_in_advance"),
    FAILED("failed"),
    FAILING("failing"),
    ABORTED("aborted");

    private final String value;

    private TaskStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public boolean hasBeenStarted() {
        return this != PLANNED && this != PENDING;
    }

    public boolean isDone() {
        return this.isOneOf(COMPLETED, SKIPPED);
    }

    public boolean isDoneInAdvance() {
        return this.isOneOf(COMPLETED_IN_ADVANCE, SKIPPED_IN_ADVANCE);
    }

    public boolean isActive() {
        return this.isOneOf(PENDING, IN_PROGRESS, FAILED, FAILING);
    }

    public boolean isOneOf(TaskStatus ... statuses) {
        for (TaskStatus status : statuses) {
            if (this != status) continue;
            return true;
        }
        return false;
    }
}

